/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.app;

import cool.scx.ansi.Ansi;
import cool.scx.ansi.AnsiElement;
import cool.scx.app.ScxAppBuilder;
import cool.scx.app.ScxAppContext;
import cool.scx.app.ScxAppHelper;
import cool.scx.app.ScxAppHttpRouter;
import cool.scx.app.ScxAppModule;
import cool.scx.app.ScxAppOptions;
import cool.scx.app.ScxAppVersion;
import cool.scx.app.enumeration.ScxAppFeature;
import cool.scx.app.eventbus.EventBus;
import cool.scx.bean.DefaultListableBeanFactory;
import cool.scx.common.count_map.CountMap;
import cool.scx.common.exception.ScxExceptionHelper;
import cool.scx.common.util.$;
import cool.scx.common.util.FileUtils;
import cool.scx.common.util.NetUtils;
import cool.scx.common.util.ScopedValue;
import cool.scx.common.util.StopWatch;
import cool.scx.config.ScxConfig;
import cool.scx.config.ScxEnvironment;
import cool.scx.config.ScxFeature;
import cool.scx.config.ScxFeatureConfig;
import cool.scx.data.jdbc.mapping.AnnotationConfigTable;
import cool.scx.http.ScxHttpServer;
import cool.scx.http.error_handler.DefaultHttpServerErrorHandler;
import cool.scx.http.error_handler.ScxHttpServerErrorHandler;
import cool.scx.http.routing.Route;
import cool.scx.http.routing.Router;
import cool.scx.http.routing.TypeMatcher;
import cool.scx.http.x.HttpServer;
import cool.scx.http.x.HttpServerOptions;
import cool.scx.http.x.http1.Http1UpgradeHandler;
import cool.scx.jdbc.JDBCContext;
import cool.scx.jdbc.SchemaHelper;
import cool.scx.jdbc.mapping.Table;
import cool.scx.jdbc.sql.SQLRunner;
import cool.scx.tcp.tls.TLS;
import cool.scx.web.RouteRegistrar;
import cool.scx.web.ScxWeb;
import cool.scx.web.ScxWebOptions;
import cool.scx.web.WebSocketRouteRegistrar;
import cool.scx.websocket.routing.WebSocketTypeMatcher;
import cool.scx.websocket.x.WebSocketUpgradeHandler;
import java.io.UncheckedIOException;
import java.net.BindException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import javax.sql.DataSource;

public final class ScxApp {
    static final System.Logger logger = System.getLogger(ScxApp.class.getName());
    private static final long DEFAULT_BODY_LIMIT = FileUtils.displaySizeToLong((String)"16384KB");
    private final ScxEnvironment scxEnvironment;
    private final String appKey;
    private final ScxFeatureConfig scxFeatureConfig;
    private final ScxConfig scxConfig;
    private final ScxAppModule[] scxModules;
    private final ScxAppOptions scxOptions;
    private final DefaultListableBeanFactory beanFactory;
    private final ScxWeb scxWeb;
    private final Object defaultHttpServerOptions;
    private final EventBus eventBus;
    private JDBCContext jdbcContext = null;
    private ScxAppHttpRouter scxHttpRouter = null;
    private ScxHttpServer httpServer = null;

    ScxApp(ScxEnvironment scxEnvironment, String appKey, ScxFeatureConfig scxFeatureConfig, ScxConfig scxConfig, ScxAppModule[] scxModules, Object defaultHttpServerOptions) {
        ScxAppContext.scx(this);
        this.scxEnvironment = scxEnvironment;
        this.appKey = appKey;
        this.scxFeatureConfig = scxFeatureConfig;
        this.scxConfig = scxConfig;
        this.scxModules = ScxAppHelper.initScxModuleMetadataList(scxModules);
        this.scxOptions = new ScxAppOptions(this.scxConfig, this.scxEnvironment, this.appKey);
        this.defaultHttpServerOptions = defaultHttpServerOptions;
        ScxAppHelper.initScxLoggerFactory(this.scxConfig, this.scxEnvironment);
        this.beanFactory = ScxAppHelper.initBeanFactory(this.scxModules, this.scxFeatureConfig);
        this.eventBus = new EventBus(Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2));
        this.scxWeb = new ScxWeb(new ScxWebOptions().templateRoot(this.scxOptions.templateRoot()));
    }

    public static ScxAppBuilder builder() {
        return new ScxAppBuilder();
    }

    private void startAllScxModules() {
        for (ScxAppModule m : this.scxModules) {
            if (((Boolean)this.scxFeatureConfig.get((ScxFeature)ScxAppFeature.SHOW_MODULE_LIFE_CYCLE_INFO)).booleanValue()) {
                Ansi.ansi().brightWhite((Object)"[", new AnsiElement[0]).brightGreen((Object)"Starting", new AnsiElement[0]).brightWhite((Object)("] " + m.name()), new AnsiElement[0]).println();
            }
            m.start(this);
            if (!((Boolean)this.scxFeatureConfig.get((ScxFeature)ScxAppFeature.SHOW_MODULE_LIFE_CYCLE_INFO)).booleanValue()) continue;
            Ansi.ansi().brightWhite((Object)"[", new AnsiElement[0]).brightGreen((Object)"Start OK", new AnsiElement[0]).brightWhite((Object)("] " + m.name()), new AnsiElement[0]).println();
        }
    }

    private void stopAllScxModules() {
        if (((Boolean)this.scxFeatureConfig.get((ScxFeature)ScxAppFeature.SHOW_MODULE_LIFE_CYCLE_INFO)).booleanValue()) {
            for (ScxAppModule m : this.scxModules) {
                Ansi.ansi().brightWhite((Object)"[", new AnsiElement[0]).brightRed((Object)"Stopping", new AnsiElement[0]).brightWhite((Object)("] " + m.name()), new AnsiElement[0]).println();
                m.stop(this);
                Ansi.ansi().brightWhite((Object)"[", new AnsiElement[0]).brightRed((Object)"Stop  OK", new AnsiElement[0]).brightWhite((Object)("] " + m.name()), new AnsiElement[0]).println();
            }
        } else {
            for (ScxAppModule m : this.scxModules) {
                m.stop(this);
            }
        }
    }

    public ScxApp run() {
        return (ScxApp)ScopedValue.where(ScxAppContext.GLOBAL_SCX, (Object)this).get(this::run0);
    }

    private ScxApp run0() {
        StopWatch.start((String)"ScxRun");
        if (((Boolean)this.scxFeatureConfig.get((ScxFeature)ScxAppFeature.SHOW_BANNER)).booleanValue()) {
            ScxAppVersion.printBanner();
        }
        if (((Boolean)this.scxFeatureConfig.get((ScxFeature)ScxAppFeature.SHOW_OPTIONS_INFO)).booleanValue()) {
            this.scxOptions.printInfo();
        }
        this.scxHttpRouter = new ScxAppHttpRouter(this);
        List classList = Arrays.stream(this.scxModules()).flatMap(c -> c.classList().stream()).toList();
        Object[] httpRoutes = RouteRegistrar.filterClass(classList).stream().map(arg_0 -> ((DefaultListableBeanFactory)this.beanFactory).getBean(arg_0)).toArray();
        Object[] webSocketRoutes = WebSocketRouteRegistrar.filterClass(classList).stream().map(arg_0 -> ((DefaultListableBeanFactory)this.beanFactory).getBean(arg_0)).toArray();
        this.scxWeb.registerHttpRoutes((Router)this.scxHttpRouter, httpRoutes).registerWebSocketRoutes((Router)this.scxHttpRouter, webSocketRoutes);
        this.startAllScxModules();
        if (((Boolean)this.scxFeatureConfig.get((ScxFeature)ScxAppFeature.SHOW_START_UP_INFO)).booleanValue()) {
            List routes = this.scxHttpRouter.getRoutes();
            CountMap entries = $.countingBy((Iterable)routes, Route::typeMatcher);
            Long a = entries.get((Object)TypeMatcher.any());
            Long b = entries.get((Object)WebSocketTypeMatcher.NOT_WEB_SOCKET_HANDSHAKE);
            Long c2 = entries.get((Object)WebSocketTypeMatcher.WEB_SOCKET_HANDSHAKE);
            Ansi.ansi().brightYellow((Object)("\u5df2\u52a0\u8f7d " + this.beanFactory.getBeanDefinitionNames().length + " \u4e2a Bean !!!"), new AnsiElement[0]).ln().brightGreen((Object)("\u5df2\u52a0\u8f7d " + ((a != null ? a : 0L) + (b != null ? b : 0L)) + " \u4e2a Http \u8def\u7531 !!!"), new AnsiElement[0]).ln().brightBlue((Object)("\u5df2\u52a0\u8f7d " + (c2 != null ? c2 : 0L) + " \u4e2a WebSocket \u8def\u7531 !!!"), new AnsiElement[0]).println();
        }
        this.httpServer = this.createServer();
        this.httpServer.onRequest((Consumer)((Object)this.scxHttpRouter));
        this.addShutdownHook();
        this.startServer(this.scxOptions.port());
        this.beanFactory.preInstantiateSingletons();
        if (((Boolean)this.scxFeatureConfig.get((ScxFeature)ScxAppFeature.ENABLE_SCHEDULING_WITH_ANNOTATION)).booleanValue()) {
            ScxAppHelper.startAnnotationScheduled(this.beanFactory);
        }
        return this;
    }

    private ScxHttpServer createServer() {
        boolean hasWebSocketUpgradeHandler;
        HttpServerOptions httpServerOptions = (this.defaultHttpServerOptions != null ? new HttpServerOptions((HttpServerOptions)this.defaultHttpServerOptions) : new HttpServerOptions()).maxPayloadSize(DEFAULT_BODY_LIMIT);
        if (this.scxOptions.isHttpsEnabled()) {
            TLS tls = TLS.of((Path)this.scxOptions.sslPath(), (String)this.scxOptions.sslPassword());
            httpServerOptions.tls(tls);
        }
        if (!(hasWebSocketUpgradeHandler = httpServerOptions.upgradeHandlerList().stream().anyMatch(http1UpgradeHandler -> http1UpgradeHandler instanceof WebSocketUpgradeHandler))) {
            httpServerOptions.addUpgradeHandler(new Http1UpgradeHandler[]{new WebSocketUpgradeHandler()});
        }
        return new HttpServer(httpServerOptions).onError((ScxHttpServerErrorHandler)new DefaultHttpServerErrorHandler(((Boolean)this.scxFeatureConfig.get((ScxFeature)ScxAppFeature.USE_DEVELOPMENT_ERROR_PAGE)).booleanValue()));
    }

    private void startServer(int port) {
        try {
            InetAddress[] normalIP;
            this.httpServer.start(port);
            String httpOrHttps = this.scxOptions.isHttpsEnabled() ? "https" : "http";
            Ansi o = Ansi.ansi().green((Object)("\u670d\u52a1\u5668\u542f\u52a8\u6210\u529f... \u7528\u65f6 " + StopWatch.stopToMillis((String)"ScxRun") + " ms"), new AnsiElement[0]).ln();
            int p = this.httpServer.localAddress().getPort();
            o.green((Object)("> \u672c\u5730: " + httpOrHttps + "://localhost:" + p + "/"), new AnsiElement[0]).ln();
            for (InetAddress ip : normalIP = (InetAddress[])ScxExceptionHelper.ignore(() -> NetUtils.getLocalIPAddress(c -> c instanceof Inet4Address), (Object)new InetAddress[0])) {
                o.green((Object)("> \u7f51\u7edc: " + httpOrHttps + "://" + ip.getHostAddress() + ":" + p + "/"), new AnsiElement[0]).ln();
            }
            o.print();
        }
        catch (Exception cause) {
            if (cause instanceof UncheckedIOException && cause.getCause() instanceof BindException) {
                if (ScxAppHelper.isUseNewPort(port)) {
                    this.startServer(0);
                }
            }
            cause.printStackTrace();
        }
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.stopAllScxModules();
            Ansi.ansi().red((Object)"\u9879\u76ee\u6b63\u5728\u505c\u6b62!!!", new AnsiElement[0]).println();
        }));
    }

    public boolean checkDataSource() {
        boolean bl;
        block8: {
            Connection conn = this.dataSource().getConnection();
            try {
                DatabaseMetaData dm = conn.getMetaData();
                logger.log(System.Logger.Level.DEBUG, "\u6570\u636e\u6e90\u8fde\u63a5\u6210\u529f : \u7c7b\u578b [{0}]  \u7248\u672c [{1}]", dm.getDatabaseProductName(), dm.getDatabaseProductVersion());
                bl = true;
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    ScxAppHelper.dataSourceExceptionHandler(e);
                    return false;
                }
            }
            conn.close();
        }
        return bl;
    }

    public void fixTable() {
        logger.log(System.Logger.Level.DEBUG, "\u4fee\u590d\u6570\u636e\u8868\u7ed3\u6784\u4e2d...");
        int fixSuccess = 0;
        int fixFail = 0;
        int noNeedToFix = 0;
        for (Class<?> v : this.getAllScxBaseModelClassList()) {
            AnnotationConfigTable tableInfo = new AnnotationConfigTable(v);
            try {
                if (SchemaHelper.checkNeedFixTable((Table)tableInfo, (DataSource)this.dataSource())) {
                    SchemaHelper.fixTable((Table)tableInfo, (JDBCContext)this.jdbcContext);
                    ++fixSuccess;
                    continue;
                }
                ++noNeedToFix;
            }
            catch (Exception e) {
                e.printStackTrace();
                ++fixFail;
            }
        }
        if (fixSuccess != 0) {
            logger.log(System.Logger.Level.DEBUG, "\u4fee\u590d\u6210\u529f {0} \u5f20\u8868...", fixSuccess);
        }
        if (fixFail != 0) {
            logger.log(System.Logger.Level.WARNING, "\u4fee\u590d\u5931\u8d25 {0} \u5f20\u8868...", fixFail);
        }
        if (fixSuccess + fixFail == 0) {
            logger.log(System.Logger.Level.DEBUG, "\u6ca1\u6709\u8868\u9700\u8981\u4fee\u590d...");
        }
    }

    private List<Class<?>> getAllScxBaseModelClassList() {
        return Arrays.stream(this.scxModules).flatMap(c -> c.classList().stream()).filter(ScxAppHelper::isScxBaseModelClass).toList();
    }

    public boolean checkNeedFixTable() {
        logger.log(System.Logger.Level.DEBUG, "\u68c0\u67e5\u6570\u636e\u8868\u7ed3\u6784\u4e2d...");
        for (Class<?> v : this.getAllScxBaseModelClassList()) {
            AnnotationConfigTable tableInfo = new AnnotationConfigTable(v);
            try {
                if (!SchemaHelper.checkNeedFixTable((Table)tableInfo, (DataSource)this.dataSource())) continue;
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public <T extends ScxAppModule> T findScxModule(Class<T> clazz) {
        for (ScxAppModule m : this.scxModules) {
            if (m.getClass() != clazz) continue;
            return (T)m;
        }
        return null;
    }

    public ScxAppModule[] scxModules() {
        return Arrays.copyOf(this.scxModules, this.scxModules.length);
    }

    public ScxEnvironment scxEnvironment() {
        return this.scxEnvironment;
    }

    public String appKey() {
        return this.appKey;
    }

    public ScxAppOptions scxOptions() {
        return this.scxOptions;
    }

    public DefaultListableBeanFactory beanFactory() {
        return this.beanFactory;
    }

    public ScxAppHttpRouter scxHttpRouter() {
        return this.scxHttpRouter;
    }

    public ScxConfig scxConfig() {
        return this.scxConfig;
    }

    public ScxFeatureConfig scxFeatureConfig() {
        return this.scxFeatureConfig;
    }

    public DataSource dataSource() {
        return this.jdbcContext().dataSource();
    }

    public SQLRunner sqlRunner() {
        return this.jdbcContext().sqlRunner();
    }

    public JDBCContext jdbcContext() {
        if (this.jdbcContext == null) {
            DataSource dataSource = ScxAppHelper.initDataSource(this.scxOptions, this.scxFeatureConfig);
            this.jdbcContext = new JDBCContext(dataSource);
        }
        return this.jdbcContext;
    }

    public ScxHttpServer httpServer() {
        return this.httpServer;
    }

    public EventBus eventBus() {
        return this.eventBus;
    }

    public ScxWeb scxWeb() {
        return this.scxWeb;
    }

    public <T> T getBean(Class<T> requiredType) {
        return (T)this.beanFactory.getBean(requiredType);
    }
}

