/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.app.eventbus;

import cool.scx.collections.multi_map.MultiMap;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class EventBus {
    private final MultiMap<String, Consumer<Object>> events = new MultiMap(ConcurrentHashMap::new, ArrayList::new);
    private final Executor executor;

    public EventBus(Executor executor) {
        this.executor = executor;
    }

    public void publish(String name, Object data) {
        List consumers = this.events.getAll((Object)name);
        for (Consumer consumer : consumers) {
            this.executor.execute(() -> consumer.accept(data));
        }
    }

    public void consumer(String name, Consumer<Object> consumer) {
        this.events.add((Object)name, consumer);
    }
}

