/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.bean;

import cool.scx.bean.BeanFactory;
import cool.scx.bean.exception.DuplicateBeanNameException;
import cool.scx.bean.exception.NoSuchBeanException;
import cool.scx.bean.exception.NoUniqueBeanException;
import cool.scx.bean.provider.AnnotationConfigBeanProvider;
import cool.scx.bean.provider.BeanProvider;
import cool.scx.bean.provider.InjectingBeanProvider;
import cool.scx.bean.provider.InstanceBeanProvider;
import cool.scx.bean.provider.SingletonBeanProvider;
import cool.scx.bean.resolver.BeanResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class BeanFactoryImpl
implements BeanFactory {
    private final Map<String, BeanProvider> beanProviderMap = new ConcurrentHashMap<String, BeanProvider>();
    private final List<BeanResolver> beanResolvers = new ArrayList<BeanResolver>();

    @Override
    public Object getBean(String name) throws NoSuchBeanException {
        return this.findBeanProvider(name).getBean(this);
    }

    @Override
    public <T> T getBean(Class<T> requiredType) throws NoSuchBeanException, NoUniqueBeanException {
        return (T)this.findBeanProvider(requiredType).getBean(this);
    }

    @Override
    public <T> T getBean(String name, Class<T> requiredType) throws NoSuchBeanException {
        return (T)this.findBeanProvider(name, requiredType).getBean(this);
    }

    @Override
    public void registerBean(String name, Object bean) {
        this.registerBeanProvider(name, new InjectingBeanProvider(new InstanceBeanProvider(bean)));
    }

    @Override
    public void registerBeanClass(String name, Class<?> beanClass, boolean singleton) throws DuplicateBeanNameException {
        if (singleton) {
            this.registerBeanProvider(name, new InjectingBeanProvider(new SingletonBeanProvider(new AnnotationConfigBeanProvider(beanClass))));
        } else {
            this.registerBeanProvider(name, new InjectingBeanProvider(new AnnotationConfigBeanProvider(beanClass)));
        }
    }

    @Override
    public void registerBeanProvider(String name, BeanProvider beanProvider) throws DuplicateBeanNameException {
        BeanProvider oldValue = this.beanProviderMap.putIfAbsent(name, beanProvider);
        if (oldValue != null) {
            throw new DuplicateBeanNameException("\u91cd\u590d\u7684 bean name, name = [" + name + "]");
        }
    }

    @Override
    public void addBeanResolver(BeanResolver beanResolver) {
        this.beanResolvers.add(beanResolver);
    }

    @Override
    public List<BeanResolver> beanResolvers() {
        return this.beanResolvers;
    }

    @Override
    public void initializeBeans() {
        for (BeanProvider entry : this.beanProviderMap.values()) {
            entry.getBean(this);
        }
    }

    @Override
    public String[] getBeanNames() {
        return (String[])this.beanProviderMap.keySet().toArray(String[]::new);
    }

    private BeanProvider findBeanProvider(String name) throws NoSuchBeanException {
        BeanProvider beanProvider = this.beanProviderMap.get(name);
        if (beanProvider == null) {
            throw new NoSuchBeanException("\u672a\u627e\u5230\u4efb\u4f55\u7b26\u5408\u540d\u79f0\u7684 bean, name = [" + name + "]");
        }
        return beanProvider;
    }

    private BeanProvider findBeanProvider(Class<?> requiredType) throws NoSuchBeanException, NoUniqueBeanException {
        Collection<BeanProvider> beanProviders = this.beanProviderMap.values();
        ArrayList<BeanProvider> list = new ArrayList<BeanProvider>();
        for (BeanProvider beanProvider : beanProviders) {
            if (!requiredType.isAssignableFrom(beanProvider.beanClass())) continue;
            list.add(beanProvider);
        }
        int size = list.size();
        if (size == 0) {
            throw new NoSuchBeanException("\u672a\u627e\u5230\u4efb\u4f55\u7b26\u5408\u7c7b\u578b\u7684 bean, class = [" + requiredType.getName() + "]");
        }
        if (size > 1) {
            throw new NoUniqueBeanException("\u627e\u5230\u591a\u4e2a\u7b26\u5408\u7c7b\u578b\u7684 bean, class = [" + requiredType.getName() + "], \u5df2\u627e\u5230 = [" + list.stream().map(c -> c.beanClass().getName()).collect(Collectors.joining(", ")) + "]");
        }
        return (BeanProvider)list.get(0);
    }

    private BeanProvider findBeanProvider(String name, Class<?> requiredType) throws NoSuchBeanException, NoUniqueBeanException {
        BeanProvider beanProvider = this.findBeanProvider(name);
        if (requiredType.isAssignableFrom(beanProvider.beanClass())) {
            return beanProvider;
        }
        throw new NoSuchBeanException("\u672a\u627e\u5230\u4efb\u4f55\u7b26\u5408\u540d\u79f0\u7684 bean, name = [" + name + "], class = [" + requiredType.getName() + "]");
    }
}

