/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.bean.provider;

import cool.scx.bean.BeanFactory;
import cool.scx.bean.exception.BeanCreationException;
import cool.scx.bean.provider.BeanProvider;
import cool.scx.bean.resolver.BeanResolver;
import cool.scx.reflect.AccessModifier;
import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.ClassInfoFactory;
import cool.scx.reflect.ConstructorInfo;
import cool.scx.reflect.ParameterInfo;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

public class AnnotationConfigBeanProvider
implements BeanProvider {
    private static final ThreadLocal<List<Class<?>>> CURRENTLY_CREATING = ThreadLocal.withInitial(ArrayList::new);
    private final Class<?> beanClass;
    private final ConstructorInfo constructor;

    public AnnotationConfigBeanProvider(Class<?> beanClass) {
        this.beanClass = beanClass;
        this.constructor = AnnotationConfigBeanProvider.findPreferredConstructor(beanClass);
    }

    public static ConstructorInfo findPreferredConstructor(Class<?> beanClass) {
        ClassInfo classInfo = ClassInfoFactory.getClassInfo(beanClass);
        for (ConstructorInfo constructor : classInfo.constructors()) {
            if (constructor.accessModifier() != AccessModifier.PUBLIC) continue;
            return constructor;
        }
        throw new IllegalArgumentException("No constructor found for " + String.valueOf(beanClass));
    }

    public static String buildCycleText(List<Class<?>> creatingList, Class<?> beanClass) {
        ArrayList<String> cycle = new ArrayList<String>();
        for (Class<?> creator : creatingList) {
            cycle.add(creator.getName());
        }
        cycle.add(beanClass.getName());
        return String.join((CharSequence)" -> ", cycle);
    }

    public Object newInstance(BeanFactory beanFactory) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        ParameterInfo[] parameters = this.constructor.parameters();
        Object[] objects = new Object[parameters.length];
        block0: for (int i = 0; i < parameters.length; ++i) {
            ParameterInfo parameter = parameters[i];
            for (BeanResolver beanResolver : beanFactory.beanResolvers()) {
                Object value = beanResolver.resolveConstructorArgument(parameter);
                if (value == null) continue;
                objects[i] = value;
                continue block0;
            }
        }
        return this.constructor.newInstance(objects);
    }

    @Override
    public Class<?> beanClass() {
        return this.beanClass;
    }

    @Override
    public Object getBean(BeanFactory beanFactory) {
        List<Class<?>> creatingList = CURRENTLY_CREATING.get();
        if (creatingList.contains(this.beanClass)) {
            String message = AnnotationConfigBeanProvider.buildCycleText(creatingList, this.beanClass);
            throw new BeanCreationException("\u68c0\u6d4b\u5230\u6784\u9020\u51fd\u6570\u5faa\u73af\u4f9d\u8d56, \u4f9d\u8d56\u94fe = [" + message + "]");
        }
        creatingList.add(this.beanClass);
        try {
            Object message = this.newInstance(beanFactory);
            return message;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new BeanCreationException("\u521b\u5efa bean \u65f6\u53d1\u751f\u5f02\u5e38 ", e.getCause());
        }
        finally {
            creatingList.removeLast();
        }
    }

    @Override
    public boolean singleton() {
        return false;
    }
}

