/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.bean.provider;

import cool.scx.bean.BeanFactory;
import cool.scx.bean.exception.BeanCreationException;
import cool.scx.bean.provider.BeanProvider;
import cool.scx.bean.resolver.BeanResolver;
import cool.scx.reflect.AccessModifier;
import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.ClassInfoFactory;
import cool.scx.reflect.FieldInfo;
import cool.scx.reflect.MethodInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class InjectingBeanProvider
implements BeanProvider {
    private static final ThreadLocal<List<InjectingBeanProvider>> CURRENTLY_CREATING = ThreadLocal.withInitial(ArrayList::new);
    private final BeanProvider beanProvider;
    private boolean alreadyInjected;

    public InjectingBeanProvider(BeanProvider beanProvider) {
        this.beanProvider = beanProvider;
        this.alreadyInjected = false;
    }

    public static boolean checkContains(List<InjectingBeanProvider> creatingList, InjectingBeanProvider injectingBeanProvider) {
        for (InjectingBeanProvider beanProvider : creatingList) {
            if (beanProvider.beanClass() != injectingBeanProvider.beanClass()) continue;
            return true;
        }
        return false;
    }

    public static boolean checkAllArePrototype(List<InjectingBeanProvider> creatingList) {
        for (InjectingBeanProvider beanClass : creatingList) {
            if (!beanClass.singleton()) continue;
            return false;
        }
        return true;
    }

    public static String buildCycleText(List<InjectingBeanProvider> creatingList, InjectingBeanProvider beanClass) {
        ArrayList<String> cycle = new ArrayList<String>();
        for (InjectingBeanProvider creator : creatingList) {
            cycle.add(creator.beanClass().getName());
        }
        cycle.add(beanClass.beanClass().getName());
        return String.join((CharSequence)" -> ", cycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getBean(BeanFactory beanFactory) {
        boolean b;
        List<InjectingBeanProvider> creatingList;
        Object bean = this.beanProvider.getBean(beanFactory);
        if (this.beanProvider.singleton()) {
            if (this.alreadyInjected) {
                return bean;
            }
            this.alreadyInjected = true;
        }
        if (InjectingBeanProvider.checkContains(creatingList = CURRENTLY_CREATING.get(), this) && (b = InjectingBeanProvider.checkAllArePrototype(creatingList))) {
            String message = InjectingBeanProvider.buildCycleText(creatingList, this);
            throw new BeanCreationException("\u68c0\u6d4b\u5230\u5b57\u6bb5\u5faa\u73af\u4f9d\u8d56\uff08\u591a\u4f8b\u7981\u6b62\uff09\uff0c\u4f9d\u8d56\u94fe = [" + message + "]");
        }
        creatingList.add(this);
        try {
            this.injectFieldAndMethod(bean, beanFactory);
        }
        finally {
            creatingList.removeLast();
        }
        return bean;
    }

    @Override
    public boolean singleton() {
        return this.beanProvider.singleton();
    }

    @Override
    public Class<?> beanClass() {
        return this.beanProvider.beanClass();
    }

    private void injectFieldAndMethod(Object bean, BeanFactory beanFactory) {
        MethodInfo[] methodInfos;
        FieldInfo[] fieldInfos;
        ClassInfo classInfo = ClassInfoFactory.getClassInfo(this.beanClass());
        block2: for (FieldInfo fieldInfo : fieldInfos = classInfo.allFields()) {
            if (fieldInfo.accessModifier() != AccessModifier.PUBLIC) continue;
            fieldInfo.setAccessible(true);
            for (BeanResolver resolver : beanFactory.beanResolvers()) {
                try {
                    Object fieldValue = resolver.resolveFieldValue(fieldInfo);
                    if (fieldValue == null) continue;
                    fieldInfo.set(bean, fieldValue);
                    continue block2;
                }
                catch (Exception e) {
                    throw new BeanCreationException("\u6ce8\u5165\u5b57\u6bb5 [" + fieldInfo.name() + "] \u9636\u6bb5\u53d1\u751f\u5f02\u5e38 !!!", e);
                }
            }
        }
        for (MethodInfo methodInfo : methodInfos = classInfo.allMethods()) {
            BeanResolver resolver;
            boolean b;
            if (methodInfo.accessModifier() != AccessModifier.PUBLIC) continue;
            methodInfo.setAccessible(true);
            Iterator<BeanResolver> iterator = beanFactory.beanResolvers().iterator();
            while (iterator.hasNext() && !(b = (resolver = iterator.next()).resolveMethod(methodInfo))) {
            }
        }
    }
}

