/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.bean.resolver;

import cool.scx.bean.BeanFactory;
import cool.scx.bean.annotation.Autowired;
import cool.scx.bean.resolver.BeanResolver;
import cool.scx.common.constant.AnnotationValueHelper;
import cool.scx.reflect.FieldInfo;
import cool.scx.reflect.MethodInfo;
import cool.scx.reflect.ParameterInfo;
import java.lang.annotation.Annotation;

public class AutowiredAnnotationResolver
implements BeanResolver {
    private final BeanFactory beanFactory;

    public AutowiredAnnotationResolver(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public Object resolveConstructorArgument(ParameterInfo parameter) {
        Annotation annotation;
        Annotation[] annotations = parameter.allAnnotations();
        if (annotations.length == 0) {
            return this.beanFactory.getBean(parameter.parameter().getType());
        }
        if (annotations.length == 1 && (annotation = annotations[0]) instanceof Autowired) {
            Autowired autowired = (Autowired)annotation;
            String name = AnnotationValueHelper.getRealValue((String)autowired.value());
            if (name != null) {
                return this.beanFactory.getBean(name, parameter.parameter().getType());
            }
            return this.beanFactory.getBean(parameter.parameter().getType());
        }
        return null;
    }

    @Override
    public Object resolveFieldValue(FieldInfo fieldInfo) {
        Autowired autowired = (Autowired)fieldInfo.findAnnotation(Autowired.class);
        if (autowired == null) {
            return null;
        }
        String name = AnnotationValueHelper.getRealValue((String)autowired.value());
        if (name != null) {
            return this.beanFactory.getBean(name, fieldInfo.field().getType());
        }
        return this.beanFactory.getBean(fieldInfo.field().getType());
    }

    @Override
    public boolean resolveMethod(MethodInfo methodInfo) {
        return false;
    }
}

