/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.bean.resolver;

import com.fasterxml.jackson.databind.JavaType;
import cool.scx.bean.annotation.Value;
import cool.scx.bean.exception.MissingValueException;
import cool.scx.bean.resolver.BeanResolver;
import cool.scx.common.util.ObjectUtils;
import cool.scx.reflect.FieldInfo;
import cool.scx.reflect.MethodInfo;
import cool.scx.reflect.ParameterInfo;
import java.util.Map;

public class ValueAnnotationResolver
implements BeanResolver {
    private final Map<String, Object> map;

    public ValueAnnotationResolver(Map<String, Object> map) {
        this.map = map;
    }

    @Override
    public Object resolveConstructorArgument(ParameterInfo parameterInfo) {
        Value annotation = (Value)parameterInfo.findAnnotation(Value.class);
        if (annotation == null) {
            return null;
        }
        Object rawValue = this.map.get(annotation.value());
        if (rawValue == null) {
            throw new MissingValueException("\u672a\u627e\u5230 @Value \u503c " + annotation.value());
        }
        return ObjectUtils.convertValue((Object)rawValue, (JavaType)parameterInfo.type());
    }

    @Override
    public Object resolveFieldValue(FieldInfo fieldInfo) {
        Value annotation = (Value)fieldInfo.findAnnotation(Value.class);
        if (annotation == null) {
            return null;
        }
        Object rawValue = this.map.get(annotation.value());
        if (rawValue == null) {
            throw new MissingValueException("\u672a\u627e\u5230 @Value \u503c " + annotation.value());
        }
        return ObjectUtils.convertValue((Object)rawValue, (JavaType)fieldInfo.type());
    }

    @Override
    public boolean resolveMethod(MethodInfo methodInfo) {
        return false;
    }
}

