/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.bean.dependency;

import cool.scx.bean.dependency.DependencyContext;
import cool.scx.bean.exception.BeanCreationException;
import java.util.ArrayList;
import java.util.List;

public class CircularDependencyChecker {
    private static final ThreadLocal<List<DependencyContext>> CURRENT_DEPENDENCY_CHAIN = ThreadLocal.withInitial(ArrayList::new);

    public static void startDependencyCheck(DependencyContext dependentContext) throws BeanCreationException {
        UnsolvableCycleType unsolvableCycleType;
        List<DependencyContext> dependencyChain = CURRENT_DEPENDENCY_CHAIN.get();
        List<DependencyContext> circularDependencyChain = CircularDependencyChecker.extractCircularDependencyChain(dependencyChain, dependentContext);
        if (circularDependencyChain != null && (unsolvableCycleType = CircularDependencyChecker.isUnsolvableCycle(circularDependencyChain)) != null) {
            String message = CircularDependencyChecker.buildCycleMessage(dependencyChain, dependentContext);
            String why = switch (unsolvableCycleType.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "\u6784\u9020\u51fd\u6570\u5faa\u73af\u4f9d\u8d56";
                case 1 -> "\u591a\u4f8b\u5faa\u73af\u4f9d\u8d56";
            };
            throw new BeanCreationException("\u5728\u521b\u5efa\u7c7b " + String.valueOf(dependentContext.beanClass()) + "\u65f6, \u68c0\u6d4b\u5230\u65e0\u6cd5\u89e3\u51b3\u7684" + why + ": \n\n" + message);
        }
        dependencyChain.add(dependentContext);
    }

    public static void endDependencyCheck() {
        List<DependencyContext> dependencyChain = CURRENT_DEPENDENCY_CHAIN.get();
        dependencyChain.removeLast();
    }

    public static List<DependencyContext> getCurrentDependencyChain() {
        return CURRENT_DEPENDENCY_CHAIN.get();
    }

    private static List<DependencyContext> extractCircularDependencyChain(List<DependencyContext> creatingList, DependencyContext context) {
        int cycleStartIndex = CircularDependencyChecker.findCycleStartIndex(creatingList, context);
        if (cycleStartIndex == -1) {
            return null;
        }
        return creatingList.subList(cycleStartIndex, creatingList.size());
    }

    private static int findCycleStartIndex(List<DependencyContext> creatingList, DependencyContext context) {
        for (int i = 0; i < creatingList.size(); ++i) {
            if (creatingList.get(i).beanClass() != context.beanClass()) continue;
            return i;
        }
        return -1;
    }

    private static UnsolvableCycleType isUnsolvableCycle(List<DependencyContext> circularDependencyChain) {
        for (DependencyContext c : circularDependencyChain) {
            if (c.type() != DependencyContext.Type.CONSTRUCTOR) continue;
            return UnsolvableCycleType.CONSTRUCTOR;
        }
        for (DependencyContext c : circularDependencyChain) {
            if (!c.singleton()) continue;
            return null;
        }
        return UnsolvableCycleType.ALL_PROTOTYPE;
    }

    private static String buildCycleMessage(List<DependencyContext> circularChain, DependencyContext dependentContext) {
        int cycleStartIndex = CircularDependencyChecker.findCycleStartIndex(circularChain, dependentContext);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < circularChain.size(); ++i) {
            DependencyContext ctx = circularChain.get(i);
            String baseInfo = ctx.beanClass().getName() + " " + CircularDependencyChecker.getDependencyDescription(ctx) + "\n";
            if (i < cycleStartIndex) {
                sb.append("    ").append(baseInfo);
                sb.append("              \ud83e\udc7b\n");
                continue;
            }
            if (i == cycleStartIndex) {
                sb.append("\u256d\u2500\u27a4 ").append(baseInfo);
                sb.append("|             \ud83e\udc7b\n");
                if (i != circularChain.size() - 1) continue;
                sb.append("\u2570\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500 (\u81ea\u6211\u5f15\u7528) \n");
                continue;
            }
            if (i < circularChain.size() - 1) {
                sb.append("|   ").append(baseInfo);
                sb.append("|             \ud83e\udc7b\n");
                continue;
            }
            sb.append("\u2570\u2500\u2500 ").append(baseInfo);
        }
        return sb.toString();
    }

    private static String getDependencyDescription(DependencyContext dependentContext) {
        return switch (dependentContext.type()) {
            default -> throw new MatchException(null, null);
            case DependencyContext.Type.CONSTRUCTOR -> "(\u6784\u9020\u53c2\u6570: " + dependentContext.parameter().name() + ")";
            case DependencyContext.Type.FIELD -> "[\u5b57\u6bb5: " + dependentContext.fieldInfo().name() + "]";
        };
    }

    private static enum UnsolvableCycleType {
        CONSTRUCTOR,
        ALL_PROTOTYPE;

    }
}

