/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.bean.resolver;

import cool.scx.bean.BeanFactory;
import cool.scx.bean.annotation.Autowired;
import cool.scx.bean.exception.NoSuchBeanException;
import cool.scx.bean.exception.NoUniqueBeanException;
import cool.scx.bean.resolver.BeanResolver;
import cool.scx.common.constant.AnnotationValueHelper;
import cool.scx.reflect.AnnotatedElementInfo;
import cool.scx.reflect.FieldInfo;
import cool.scx.reflect.ParameterInfo;
import java.lang.annotation.Annotation;

public class AutowiredAnnotationResolver
implements BeanResolver {
    private final BeanFactory beanFactory;

    public AutowiredAnnotationResolver(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object resolveValue(AnnotatedElementInfo annotatedElementInfo, Class<?> clazz) throws NoSuchBeanException, NoUniqueBeanException {
        Autowired autowired = (Autowired)annotatedElementInfo.findAnnotation(Autowired.class);
        if (autowired == null) {
            return null;
        }
        String name = AnnotationValueHelper.getRealValue((String)autowired.value());
        if (name != null) {
            return this.beanFactory.getBean(name, clazz);
        }
        return this.beanFactory.getBean(clazz);
    }

    @Override
    public Object resolveConstructorArgument(ParameterInfo parameter) {
        Annotation[] annotations = parameter.allAnnotations();
        if (annotations.length == 0) {
            return this.beanFactory.getBean(parameter.parameter().getType());
        }
        return this.resolveValue((AnnotatedElementInfo)parameter, parameter.parameter().getType());
    }

    @Override
    public Object resolveFieldValue(FieldInfo fieldInfo) {
        return this.resolveValue((AnnotatedElementInfo)fieldInfo, fieldInfo.field().getType());
    }
}

