/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.bean.provider;

import cool.scx.bean.BeanFactory;
import cool.scx.bean.annotation.PreferredConstructor;
import cool.scx.bean.dependency.CircularDependencyChecker;
import cool.scx.bean.dependency.DependencyContext;
import cool.scx.bean.exception.BeanCreationException;
import cool.scx.bean.exception.IllegalBeanClassException;
import cool.scx.bean.exception.NoSuchConstructorException;
import cool.scx.bean.exception.NoUniqueConstructorException;
import cool.scx.bean.provider.BeanProvider;
import cool.scx.bean.resolver.BeanResolver;
import cool.scx.reflect.AccessModifier;
import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.ClassInfoFactory;
import cool.scx.reflect.ClassType;
import cool.scx.reflect.ConstructorInfo;
import cool.scx.reflect.ParameterInfo;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

public class AnnotationConfigBeanProvider
implements BeanProvider {
    private final Class<?> beanClass;
    private final ConstructorInfo constructor;

    public AnnotationConfigBeanProvider(Class<?> beanClass) throws IllegalBeanClassException, NoSuchConstructorException, NoUniqueConstructorException {
        AnnotationConfigBeanProvider.checkClass(beanClass);
        this.beanClass = beanClass;
        this.constructor = AnnotationConfigBeanProvider.findPreferredConstructor(beanClass);
    }

    public static void checkClass(Class<?> beanClass) throws IllegalBeanClassException {
        ClassInfo classInfo = ClassInfoFactory.getClassInfo(beanClass);
        ClassType classType = classInfo.classType();
        if (classType == ClassType.CONCRETE && classInfo.isMemberClass() && !classInfo.isStatic()) {
            throw new IllegalBeanClassException("beanClass " + beanClass.getName() + " \u4e0d\u652f\u6301\u975e\u9759\u6001\u7684\u6210\u5458\u7c7b ");
        }
        if (classType == ClassType.INTERFACE) {
            throw new IllegalBeanClassException("beanClass " + beanClass.getName() + " is an interface");
        }
        if (classType == ClassType.ABSTRACT_CLASS) {
            throw new IllegalBeanClassException("beanClass " + beanClass.getName() + " is an abstract class");
        }
        if (classType == ClassType.ANNOTATION) {
            throw new IllegalBeanClassException("beanClass " + beanClass.getName() + " is an annotation");
        }
        if (classType == ClassType.ENUM) {
            throw new IllegalBeanClassException("beanClass " + beanClass.getName() + " is an enum");
        }
    }

    public static ConstructorInfo findPreferredConstructor(Class<?> beanClass) throws NoSuchConstructorException, NoUniqueConstructorException {
        ClassInfo classInfo = ClassInfoFactory.getClassInfo(beanClass);
        ArrayList<ConstructorInfo> publicConstructors = new ArrayList<ConstructorInfo>();
        for (ConstructorInfo constructor : classInfo.constructors()) {
            if (constructor.accessModifier() != AccessModifier.PUBLIC) continue;
            publicConstructors.add(constructor);
        }
        if (publicConstructors.isEmpty()) {
            throw new NoSuchConstructorException("\u65e0\u6cd5\u627e\u5230\u7c7b " + beanClass.getName() + " \u7684\u4efb\u4f55 public \u6784\u9020\u65b9\u6cd5,\u81f3\u5c11\u9700\u8981\u4e00\u4e2a public \u6784\u9020\u65b9\u6cd5\u7528\u4e8e\u521b\u5efa Bean.");
        }
        if (publicConstructors.size() == 1) {
            return (ConstructorInfo)publicConstructors.get(0);
        }
        ArrayList<ConstructorInfo> preferredConstructors = new ArrayList<ConstructorInfo>();
        for (ConstructorInfo constructorInfo : publicConstructors) {
            if (constructorInfo.findAnnotation(PreferredConstructor.class) == null) continue;
            preferredConstructors.add(constructorInfo);
        }
        if (preferredConstructors.isEmpty()) {
            throw new NoUniqueConstructorException("\u5728\u7c7b " + beanClass.getName() + " \u4e2d\u68c0\u6d4b\u5230\u591a\u4e2a public \u6784\u9020\u65b9\u6cd5, \u4e14\u90fd\u672a\u6807\u6ce8 @PreferredConstructor \u6ce8\u89e3,\u65e0\u6cd5\u786e\u5b9a\u5e94\u4f7f\u7528\u54ea\u4e2a\u6784\u9020\u65b9\u6cd5. \n\u53ef\u7528\u7684 public \u6784\u9020\u65b9\u6cd5\u5217\u8868: \n" + AnnotationConfigBeanProvider.formatConstructors(publicConstructors) + "\n\u8bf7\u5728\u671f\u671b\u4f7f\u7528\u7684\u6784\u9020\u65b9\u6cd5\u4e0a\u6dfb\u52a0 @PreferredConstructor \u6ce8\u89e3. ");
        }
        if (preferredConstructors.size() == 1) {
            return (ConstructorInfo)preferredConstructors.get(0);
        }
        throw new NoUniqueConstructorException("\u5728\u7c7b " + beanClass.getName() + " \u4e2d\u68c0\u6d4b\u5230\u591a\u4e2a\u6807\u6ce8\u4e86 @PreferredConstructor \u6ce8\u89e3\u7684 public \u6784\u9020\u65b9\u6cd5, \u65e0\u6cd5\u552f\u4e00\u786e\u5b9a\u4f7f\u7528\u54ea\u4e2a\u6784\u9020\u65b9\u6cd5. \n\u51b2\u7a81\u7684\u6784\u9020\u65b9\u6cd5\u5217\u8868: \n" + AnnotationConfigBeanProvider.formatConstructors(preferredConstructors) + "\n\u540c\u4e00\u4e2a\u7c7b\u4e2d\u53ea\u80fd\u6709\u4e00\u4e2a\u6784\u9020\u65b9\u6cd5\u6807\u6ce8 @PreferredConstructor, \u8bf7\u68c0\u67e5\u4fee\u6b63.");
    }

    private static String formatConstructors(List<ConstructorInfo> constructors) {
        StringBuilder builder = new StringBuilder();
        for (ConstructorInfo constructor : constructors) {
            builder.append("  - ").append(constructor.constructor().toGenericString()).append("\n");
        }
        return builder.toString();
    }

    public static Object resolveConstructorArgument(BeanFactory beanFactory, ParameterInfo parameter) {
        for (BeanResolver beanResolver : beanFactory.beanResolvers()) {
            Object value = beanResolver.resolveConstructorArgument(parameter);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public Class<?> beanClass() {
        return this.beanClass;
    }

    @Override
    public Object getBean(BeanFactory beanFactory) {
        ParameterInfo[] parameters = this.constructor.parameters();
        Object[] objects = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            ParameterInfo parameter = parameters[i];
            CircularDependencyChecker.startDependencyCheck(new DependencyContext(this.beanClass, false, this.constructor, parameter));
            try {
                objects[i] = AnnotationConfigBeanProvider.resolveConstructorArgument(beanFactory, parameter);
                continue;
            }
            catch (Exception e) {
                throw new BeanCreationException("\u5728\u7c7b " + this.beanClass.getName() + "\u4e2d, \u89e3\u6790\u6784\u9020\u53c2\u6570 " + parameter.name() + " \u65f6\u53d1\u751f\u5f02\u5e38 ", e);
            }
            finally {
                CircularDependencyChecker.endDependencyCheck();
            }
        }
        try {
            return this.constructor.newInstance(objects);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new BeanCreationException("\u5728\u7c7b " + this.beanClass.getName() + "\u4e2d, \u521b\u5efa bean \u65f6\u53d1\u751f\u5f02\u5e38 ", e);
        }
        catch (InvocationTargetException e) {
            throw new BeanCreationException("\u5728\u7c7b " + this.beanClass.getName() + "\u4e2d, \u521b\u5efa bean \u65f6\u53d1\u751f\u5f02\u5e38 ", e.getCause());
        }
    }

    @Override
    public boolean singleton() {
        return false;
    }
}

