/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.bean.provider;

import cool.scx.bean.BeanFactory;
import cool.scx.bean.dependency.CircularDependencyChecker;
import cool.scx.bean.dependency.DependencyContext;
import cool.scx.bean.exception.BeanCreationException;
import cool.scx.bean.provider.BeanProvider;
import cool.scx.bean.resolver.BeanResolver;
import cool.scx.reflect.AccessModifier;
import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.FieldInfo;
import cool.scx.reflect.ScxReflect;
import java.util.List;

public class InjectingBeanProvider
implements BeanProvider {
    private final BeanProvider beanProvider;
    private BeanStatus beanStatus;

    public InjectingBeanProvider(BeanProvider beanProvider) {
        this.beanProvider = beanProvider;
        this.beanStatus = BeanStatus.NULL;
    }

    public static Object resolveFieldValue(BeanFactory beanFactory, FieldInfo fieldInfo) {
        for (BeanResolver beanResolver : beanFactory.beanResolvers()) {
            Object value = beanResolver.resolveFieldValue(fieldInfo);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private static boolean shouldReturnEarly(Class<?> beanClass) {
        CircularDependencyChecker.UnsolvableCycleType unsolvableCycleType;
        List<DependencyContext> dependencyChain = CircularDependencyChecker.getCurrentDependencyChain();
        if (dependencyChain.isEmpty()) {
            return false;
        }
        List<DependencyContext> circularDependencyChain = CircularDependencyChecker.extractCircularDependencyChain(dependencyChain, beanClass);
        return circularDependencyChain == null || (unsolvableCycleType = CircularDependencyChecker.isUnsolvableCycle(circularDependencyChain)) == null;
    }

    @Override
    public Object getBean(BeanFactory beanFactory) {
        Object bean = this.beanProvider.getBean(beanFactory);
        if (this.beanProvider.singleton()) {
            if (this.beanStatus == BeanStatus.READY) {
                return bean;
            }
            if (this.beanStatus == BeanStatus.INJECTING && InjectingBeanProvider.shouldReturnEarly(this.beanClass())) {
                return bean;
            }
            this.beanStatus = BeanStatus.INJECTING;
            this.injectField(bean, beanFactory);
            this.beanStatus = BeanStatus.READY;
        } else {
            this.injectField(bean, beanFactory);
        }
        return bean;
    }

    @Override
    public boolean singleton() {
        return this.beanProvider.singleton();
    }

    @Override
    public Class<?> beanClass() {
        return this.beanProvider.beanClass();
    }

    private void injectField(Object bean, BeanFactory beanFactory) throws BeanCreationException {
        FieldInfo[] fieldInfos;
        ClassInfo classInfo = (ClassInfo)ScxReflect.typeOf(this.beanClass());
        for (FieldInfo fieldInfo : fieldInfos = classInfo.allFields()) {
            if (fieldInfo.accessModifier() != AccessModifier.PUBLIC || fieldInfo.isFinal()) continue;
            CircularDependencyChecker.startDependencyCheck(new DependencyContext(this.beanClass(), this.singleton(), fieldInfo));
            try {
                Object value = InjectingBeanProvider.resolveFieldValue(beanFactory, fieldInfo);
                if (value == null) continue;
                fieldInfo.set(bean, value);
            }
            catch (Exception e) {
                throw new BeanCreationException("\u5728\u7c7b " + this.beanClass().getName() + " \u4e2d, \u6ce8\u5165\u5b57\u6bb5 [" + fieldInfo.name() + "] \u9636\u6bb5\u53d1\u751f\u5f02\u5e38 !!!", e);
            }
            finally {
                CircularDependencyChecker.endDependencyCheck();
            }
        }
    }

    public static enum BeanStatus {
        NULL,
        INJECTING,
        READY;

    }
}

