/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.bytes;

public final class ByteChunk {
    public final byte[] bytes;
    public final int startPosition;
    public final int endPosition;
    public final int length;

    public ByteChunk(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public ByteChunk(byte[] bytes, int startPosition, int endPosition) {
        this.bytes = bytes;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.length = endPosition - startPosition;
    }

    public byte getByte(int index) {
        return this.bytes[this.startPosition + index];
    }

    public byte[] getBytes(int start, int end) {
        if (start == 0 && end == this.length && this.startPosition == 0 && this.length == this.bytes.length) {
            return this.bytes;
        }
        byte[] data = new byte[end - start];
        System.arraycopy(this.bytes, this.startPosition + start, data, 0, data.length);
        return data;
    }

    public byte[] getBytes(int start) {
        return this.getBytes(start, this.length);
    }

    public byte[] getBytes() {
        return this.getBytes(0, this.length);
    }

    public String toString(int start, int end) {
        return new String(this.bytes, this.startPosition + start, end - start);
    }

    public String toString(int start) {
        return this.toString(start, this.length);
    }

    public String toString() {
        return this.toString(0, this.length);
    }

    public ByteChunk splice(int start, int end) {
        if (start == 0 && end == this.length) {
            return this;
        }
        return new ByteChunk(this.bytes, this.startPosition + start, this.startPosition + end);
    }
}

