/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.bytes.consumer;

import cool.scx.bytes.ByteChunk;
import cool.scx.bytes.ByteNode;
import cool.scx.bytes.consumer.ByteConsumer;

public class ByteArrayByteConsumer
implements ByteConsumer {
    private ByteNode head = null;
    private ByteNode tail = null;
    private int total = 0;

    @Override
    public boolean accept(ByteChunk byteChunk) {
        this.total += byteChunk.length;
        ByteNode dataNode = new ByteNode(byteChunk);
        this.tail = this.head == null ? (this.head = dataNode) : (this.tail.next = dataNode);
        return true;
    }

    public byte[] getBytes() {
        ByteNode node = this.head;
        if (node == null) {
            return new byte[0];
        }
        if (node.next == null) {
            return node.chunk.getBytes(node.position);
        }
        byte[] bytes = new byte[this.total];
        int offset = 0;
        do {
            int length = node.available();
            int chunkOffset = node.chunk.startPosition + node.position;
            System.arraycopy(node.chunk.bytes, chunkOffset, bytes, offset, length);
            offset += length;
        } while ((node = node.next) != null);
        return bytes;
    }
}

