/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.bytes.consumer;

import cool.scx.bytes.ByteChunk;
import cool.scx.bytes.consumer.ByteConsumer;
import java.nio.ByteBuffer;

public class FillByteBufferByteConsumer
implements ByteConsumer {
    private final ByteBuffer data;
    private final int dataPosition;

    public FillByteBufferByteConsumer(ByteBuffer data) {
        this.data = data;
        this.dataPosition = data.position();
    }

    @Override
    public boolean accept(ByteChunk byteChunk) {
        if (this.data.remaining() < byteChunk.length) {
            throw new IllegalStateException("Buffer overflow: not enough space to accept more data");
        }
        this.data.put(byteChunk.bytes, byteChunk.startPosition, byteChunk.length);
        return true;
    }

    public int getFilledLength() {
        return this.data.position() - this.dataPosition;
    }
}

