/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.bytes.consumer;

import cool.scx.bytes.ByteChunk;
import cool.scx.bytes.consumer.ByteConsumer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;

public class OutputStreamByteConsumer
implements ByteConsumer {
    private final OutputStream out;
    private long byteCount;

    public OutputStreamByteConsumer(OutputStream out) {
        this.out = out;
        this.byteCount = 0L;
    }

    @Override
    public boolean accept(ByteChunk chunk) {
        try {
            this.out.write(chunk.bytes, chunk.start, chunk.length);
            this.byteCount += (long)chunk.length;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return true;
    }

    public long byteCount() {
        return this.byteCount;
    }
}

