/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.bytes.supplier;

import cool.scx.bytes.ByteChunk;
import cool.scx.bytes.exception.ByteSupplierException;
import cool.scx.bytes.supplier.ByteSupplier;
import java.util.Iterator;
import java.util.List;

public class SequenceByteSupplier
implements ByteSupplier {
    private final Iterator<ByteSupplier> iterator;
    private ByteSupplier currentSupplier;

    public SequenceByteSupplier(List<ByteSupplier> dataSupplierList) {
        this.iterator = dataSupplierList.iterator();
        if (this.iterator.hasNext()) {
            this.currentSupplier = this.iterator.next();
        }
    }

    public SequenceByteSupplier(ByteSupplier ... dataSupplierList) {
        this.iterator = List.of(dataSupplierList).iterator();
        if (this.iterator.hasNext()) {
            this.currentSupplier = this.iterator.next();
        }
    }

    @Override
    public ByteChunk get() throws ByteSupplierException {
        while (this.currentSupplier != null) {
            ByteChunk dataNode = this.currentSupplier.get();
            if (dataNode != null) {
                return dataNode;
            }
            if (this.iterator.hasNext()) {
                this.currentSupplier = this.iterator.next();
                continue;
            }
            this.currentSupplier = null;
        }
        return null;
    }
}

