/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.bytes;

public final class ByteChunk {
    public final byte[] bytes;
    public final int start;
    public final int end;
    public final int length;

    public ByteChunk(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public ByteChunk(byte[] bytes, int start, int end) {
        this.bytes = bytes;
        this.start = start;
        this.end = end;
        this.length = end - start;
    }

    public byte getByte(int index) {
        return this.bytes[this.start + index];
    }

    public byte[] getBytes(int start, int end) {
        if (start == 0 && end == this.length && this.start == 0 && this.length == this.bytes.length) {
            return this.bytes;
        }
        byte[] data = new byte[end - start];
        System.arraycopy(this.bytes, this.start + start, data, 0, data.length);
        return data;
    }

    public byte[] getBytes(int start) {
        return this.getBytes(start, this.length);
    }

    public byte[] getBytes() {
        return this.getBytes(0, this.length);
    }

    public String toString(int start, int end) {
        return new String(this.bytes, this.start + start, end - start);
    }

    public String toString(int start) {
        return this.toString(start, this.length);
    }

    public String toString() {
        return this.toString(0, this.length);
    }

    public ByteChunk subChunk(int start, int end) {
        if (start == 0 && end == this.length) {
            return this;
        }
        return new ByteChunk(this.bytes, this.start + start, this.start + end);
    }
}

