/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.bytes.indexer;

import cool.scx.bytes.ByteChunk;
import cool.scx.bytes.indexer.ByteIndexer;

public class KMPByteIndexer
implements ByteIndexer {
    private final int[] lps;
    private final byte[] pattern;
    private int patternIndex;

    public KMPByteIndexer(byte[] pattern) {
        this.pattern = pattern;
        this.patternIndex = 0;
        this.lps = KMPByteIndexer.computeLPSArray(pattern);
    }

    public static int[] computeLPSArray(byte[] pattern) {
        int[] lps = new int[pattern.length];
        int length = 0;
        int i = 1;
        while (i < pattern.length) {
            if (pattern[i] == pattern[length]) {
                lps[i] = ++length;
                ++i;
                continue;
            }
            if (length != 0) {
                length = lps[length - 1];
                continue;
            }
            lps[i] = 0;
            ++i;
        }
        return lps;
    }

    @Override
    public int indexOf(ByteChunk chunk) {
        for (int i = 0; i < chunk.length; ++i) {
            while (this.patternIndex > 0 && chunk.getByte(i) != this.pattern[this.patternIndex]) {
                this.patternIndex = this.lps[this.patternIndex - 1];
            }
            if (chunk.getByte(i) == this.pattern[this.patternIndex]) {
                ++this.patternIndex;
            }
            if (this.patternIndex != this.pattern.length) continue;
            int result = i - this.patternIndex + 1;
            this.patternIndex = 0;
            return result;
        }
        return Integer.MIN_VALUE;
    }

    public void reset() {
        this.patternIndex = 0;
    }

    public int patternIndex() {
        return this.patternIndex;
    }

    public byte[] pattern() {
        return this.pattern;
    }
}

