/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.bytes.supplier;

import cool.scx.bytes.ByteChunk;
import cool.scx.bytes.IByteReader;
import cool.scx.bytes.exception.ByteSupplierException;
import cool.scx.bytes.exception.NoMatchFoundException;
import cool.scx.bytes.exception.NoMoreDataException;
import cool.scx.bytes.indexer.KMPByteIndexer;
import cool.scx.bytes.supplier.ByteSupplier;
import java.util.Arrays;

public class BoundaryByteSupplier
implements ByteSupplier {
    private final IByteReader dataReader;
    private final KMPByteIndexer dataIndexer;
    private final int bufferLength;
    private boolean isFinish = false;

    public BoundaryByteSupplier(IByteReader dataReader, byte[] boundaryBytes) {
        this(dataReader, boundaryBytes, 8192);
    }

    public BoundaryByteSupplier(IByteReader dataReader, byte[] boundaryBytes, int bufferLength) {
        this.dataReader = dataReader;
        this.dataIndexer = new KMPByteIndexer(boundaryBytes);
        this.bufferLength = bufferLength;
    }

    @Override
    public ByteChunk get() throws ByteSupplierException {
        if (this.isFinish) {
            return null;
        }
        try {
            long index = this.dataReader.indexOf(this.dataIndexer, (long)this.bufferLength, Long.MAX_VALUE);
            byte[] read = this.dataReader.read((int)index);
            this.isFinish = true;
            return new ByteChunk(read);
        }
        catch (NoMatchFoundException e) {
            if (this.dataIndexer.patternIndex() == 0) {
                byte[] read = this.dataReader.read(this.bufferLength);
                return new ByteChunk(read);
            }
            byte[] peek = this.dataReader.peek(this.dataIndexer.pattern().length);
            boolean match = Arrays.equals(peek, this.dataIndexer.pattern());
            if (match) {
                this.isFinish = true;
                return null;
            }
            this.dataReader.skip(this.dataIndexer.pattern().length);
            return new ByteChunk(peek);
        }
        catch (NoMoreDataException e) {
            return null;
        }
    }
}

