/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.bytes;

import cool.scx.bytes.ByteChunk;
import cool.scx.bytes.ByteNode;
import cool.scx.bytes.IByteReader;
import cool.scx.bytes.consumer.ByteArrayByteConsumer;
import cool.scx.bytes.consumer.ByteConsumer;
import cool.scx.bytes.consumer.FillByteArrayByteConsumer;
import cool.scx.bytes.consumer.OutputStreamByteConsumer;
import cool.scx.bytes.exception.ByteSupplierException;
import cool.scx.bytes.exception.NoMatchFoundException;
import cool.scx.bytes.exception.NoMoreDataException;
import cool.scx.bytes.indexer.ByteIndexer;
import cool.scx.bytes.supplier.ByteSupplier;
import java.io.IOException;
import java.io.OutputStream;

public final class ByteReader
implements IByteReader {
    public final ByteSupplier byteSupplier;
    public ByteNode head;
    public ByteNode tail;
    public ByteNode markNode;
    public int markNodePosition;

    public ByteReader(ByteSupplier byteSupplier) {
        this.byteSupplier = byteSupplier;
        this.tail = this.head = new ByteNode(new ByteChunk(new byte[0]));
        this.markNode = null;
        this.markNodePosition = 0;
    }

    public ByteReader() {
        this(() -> null);
    }

    private void appendByteChunk(ByteChunk byteChunk) {
        this.tail = this.tail.next = new ByteNode(byteChunk);
    }

    private boolean pullByteChunk() throws ByteSupplierException {
        ByteChunk byteChunk = this.byteSupplier.get();
        if (byteChunk == null) {
            return false;
        }
        this.appendByteChunk(byteChunk);
        return true;
    }

    private long ensureAvailable(long maxPullCount) throws ByteSupplierException {
        long pullCount = 0L;
        while (!this.head.hasAvailable()) {
            if (this.head.next == null) {
                if (pullCount >= maxPullCount) break;
                boolean result = this.pullByteChunk();
                if (!result) {
                    return -1L;
                }
                ++pullCount;
            }
            this.head = this.head.next;
        }
        return pullCount;
    }

    private long ensureAvailableOrThrow(long maxPullCount) throws NoMoreDataException, ByteSupplierException {
        long b = this.ensureAvailable(maxPullCount);
        if (b == -1L) {
            throw new NoMoreDataException();
        }
        return b;
    }

    private <E extends Throwable> void walk(ByteConsumer<E> consumer, long maxLength, boolean movePointer, long maxPullCount) throws ByteSupplierException, E {
        long remaining = maxLength;
        ByteNode n = this.head;
        long pullCount = 0L;
        boolean needMore = true;
        while (remaining > 0L) {
            int length = (int)Math.min(remaining, (long)n.available());
            needMore = consumer.accept(n.chunk.subChunk(n.position, n.position + length));
            remaining -= (long)length;
            if (movePointer) {
                n.position += length;
            }
            if (remaining <= 0L || !needMore) break;
            if (n.next == null) {
                boolean result;
                if (pullCount >= maxPullCount || !(result = this.pullByteChunk())) break;
                ++pullCount;
            }
            n = n.next;
            if (!movePointer) continue;
            this.head = n;
        }
    }

    private long findIndex(ByteIndexer indexer, long maxLength, long maxPullCount) throws NoMatchFoundException, ByteSupplierException {
        long index = 0L;
        ByteNode n = this.head;
        long pullCount = 0L;
        while (true) {
            int length;
            int i;
            if ((i = indexer.indexOf(n.chunk.subChunk(n.position, n.position + (length = (int)Math.min((long)n.available(), maxLength - index))))) != Integer.MIN_VALUE) {
                return index + (long)i;
            }
            if ((index += (long)length) >= maxLength) break;
            if (n.next == null) {
                boolean result;
                if (pullCount >= maxPullCount || !(result = this.pullByteChunk())) break;
                ++pullCount;
            }
            n = n.next;
        }
        throw new NoMatchFoundException();
    }

    @Override
    public byte read() throws NoMoreDataException, ByteSupplierException {
        this.ensureAvailableOrThrow(Long.MAX_VALUE);
        byte b = this.head.chunk.getByte(this.head.position);
        ++this.head.position;
        return b;
    }

    @Override
    public <E extends Throwable> void read(ByteConsumer<E> byteConsumer, long maxLength, long maxPullCount) throws NoMoreDataException, ByteSupplierException, E {
        if (maxLength > 0L) {
            long pullCount = this.ensureAvailableOrThrow(maxPullCount);
            maxPullCount -= pullCount;
        }
        this.walk(byteConsumer, maxLength, true, maxPullCount);
    }

    @Override
    public byte peek() throws NoMoreDataException, ByteSupplierException {
        this.ensureAvailableOrThrow(Long.MAX_VALUE);
        return this.head.chunk.getByte(this.head.position);
    }

    @Override
    public <E extends Throwable> void peek(ByteConsumer<E> byteConsumer, long maxLength, long maxPullCount) throws NoMoreDataException, ByteSupplierException, E {
        if (maxLength > 0L) {
            long pullCount = this.ensureAvailableOrThrow(maxPullCount);
            maxPullCount -= pullCount;
        }
        this.walk(byteConsumer, maxLength, false, maxPullCount);
    }

    @Override
    public long indexOf(ByteIndexer indexer, long maxLength, long maxPullCount) throws NoMatchFoundException, NoMoreDataException, ByteSupplierException {
        if (maxLength > 0L) {
            long pullCount = this.ensureAvailableOrThrow(maxPullCount);
            maxPullCount -= pullCount;
        }
        return this.findIndex(indexer, maxLength, maxPullCount);
    }

    @Override
    public void mark() {
        this.markNode = this.head;
        this.markNodePosition = this.head.position;
    }

    @Override
    public void reset() {
        if (this.markNode == null) {
            return;
        }
        this.head = this.markNode;
        this.head.position = this.markNodePosition;
        ByteNode n = this.head.next;
        while (n != null) {
            n.reset();
            n = n.next;
        }
    }

    @Override
    public int inputStreamRead() throws IOException {
        try {
            long pullCount = this.ensureAvailable(1L);
            if (pullCount == -1L) {
                return -1;
            }
            byte b = this.head.chunk.getByte(this.head.position);
            ++this.head.position;
            return b & 0xFF;
        }
        catch (ByteSupplierException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof IOException) {
                IOException i = (IOException)throwable;
                throw i;
            }
            throw e;
        }
    }

    @Override
    public int inputStreamRead(byte[] b, int off, int len) throws IOException {
        try {
            long maxPullCount = 1L;
            if (len > 0) {
                long pullCount = this.ensureAvailable(maxPullCount);
                if (pullCount == -1L) {
                    return -1;
                }
                maxPullCount -= pullCount;
            }
            FillByteArrayByteConsumer consumer = new FillByteArrayByteConsumer(b, off, len);
            this.walk(consumer, len, true, maxPullCount);
            return consumer.filledLength();
        }
        catch (ByteSupplierException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof IOException) {
                IOException i = (IOException)throwable;
                throw i;
            }
            throw e;
        }
    }

    @Override
    public long inputStreamTransferTo(OutputStream out, long maxLength) throws IOException {
        try {
            long pullCount;
            if (maxLength > 0L && (pullCount = this.ensureAvailable(Long.MAX_VALUE)) == -1L) {
                return 0L;
            }
            OutputStreamByteConsumer consumer = new OutputStreamByteConsumer(out);
            this.walk(consumer, maxLength, true, Long.MAX_VALUE);
            return consumer.bytesWritten();
        }
        catch (ByteSupplierException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof IOException) {
                IOException i = (IOException)throwable;
                throw i;
            }
            throw e;
        }
    }

    @Override
    public byte[] inputStreamReadNBytes(long len) throws IOException {
        try {
            long pullCount;
            if (len > 0L && (pullCount = this.ensureAvailable(Long.MAX_VALUE)) == -1L) {
                return new byte[0];
            }
            ByteArrayByteConsumer consumer = new ByteArrayByteConsumer();
            this.walk(consumer, len, true, Long.MAX_VALUE);
            return consumer.bytes();
        }
        catch (ByteSupplierException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof IOException) {
                IOException i = (IOException)throwable;
                throw i;
            }
            throw e;
        }
    }
}

