/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.bytes.supplier;

import cool.scx.bytes.ByteChunk;
import cool.scx.bytes.exception.ByteSupplierException;
import cool.scx.bytes.supplier.ByteSupplier;
import java.io.IOException;
import java.io.InputStream;

public final class BufferedInputStreamByteSupplier
implements ByteSupplier {
    private final InputStream inputStream;
    private final byte[] buffer;

    public BufferedInputStreamByteSupplier(InputStream inputStream, int bufferLength) {
        this.inputStream = inputStream;
        this.buffer = new byte[bufferLength];
    }

    public BufferedInputStreamByteSupplier(InputStream inputStream) {
        this(inputStream, 8192);
    }

    @Override
    public ByteChunk get() throws ByteSupplierException {
        try {
            int i = this.inputStream.read(this.buffer);
            if (i == -1) {
                return null;
            }
            byte[] data = new byte[i];
            System.arraycopy(this.buffer, 0, data, 0, i);
            return new ByteChunk(data);
        }
        catch (IOException e) {
            throw new ByteSupplierException(e);
        }
    }
}

