/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.bytes.supplier;

import cool.scx.bytes.ByteChunk;
import cool.scx.bytes.exception.ByteSupplierException;
import cool.scx.bytes.supplier.ByteSupplier;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public final class ByteChannelByteSupplier
implements ByteSupplier {
    private final ReadableByteChannel dataChannel;
    private final int bufferLength;
    private final boolean compress;

    public ByteChannelByteSupplier(ReadableByteChannel dataChannel) {
        this(dataChannel, 8192, false);
    }

    public ByteChannelByteSupplier(ReadableByteChannel dataChannel, boolean compress) {
        this(dataChannel, 8192, compress);
    }

    public ByteChannelByteSupplier(ReadableByteChannel dataChannel, int bufferLength) {
        this(dataChannel, bufferLength, false);
    }

    public ByteChannelByteSupplier(ReadableByteChannel dataChannel, int bufferLength, boolean compress) {
        this.dataChannel = dataChannel;
        this.bufferLength = bufferLength;
        this.compress = compress;
    }

    @Override
    public ByteChunk get() throws ByteSupplierException {
        try {
            ByteBuffer bytes = ByteBuffer.allocate(this.bufferLength);
            int i = this.dataChannel.read(bytes);
            if (i == -1) {
                return null;
            }
            if (i == this.bufferLength) {
                return new ByteChunk(bytes.array());
            }
            if (this.compress) {
                byte[] data = new byte[i];
                System.arraycopy(bytes.array(), 0, data, 0, i);
                return new ByteChunk(data);
            }
            return new ByteChunk(bytes.array(), 0, i);
        }
        catch (IOException e) {
            throw new ByteSupplierException(e);
        }
    }
}

