/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.bytes.consumer;

import cool.scx.bytes.ByteChunk;
import cool.scx.bytes.consumer.ByteConsumer;
import java.io.IOException;
import java.io.OutputStream;

public final class OutputStreamByteConsumer
implements ByteConsumer<IOException> {
    private final OutputStream out;
    private long bytesWritten;

    public OutputStreamByteConsumer(OutputStream out) {
        this.out = out;
        this.bytesWritten = 0L;
    }

    @Override
    public boolean accept(ByteChunk chunk) throws IOException {
        this.out.write(chunk.bytes, chunk.start, chunk.length);
        this.bytesWritten += (long)chunk.length;
        return true;
    }

    public long bytesWritten() {
        return this.bytesWritten;
    }
}

