/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.bytes.supplier;

import cool.scx.bytes.ByteChunk;
import cool.scx.bytes.exception.ByteSupplierException;
import cool.scx.bytes.supplier.ByteSupplier;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public final class BufferedByteChannelByteSupplier
implements ByteSupplier {
    private final ReadableByteChannel dataChannel;
    private final ByteBuffer buffer;

    public BufferedByteChannelByteSupplier(ReadableByteChannel dataChannel, int bufferLength) {
        this.dataChannel = dataChannel;
        this.buffer = ByteBuffer.allocate(bufferLength);
    }

    public BufferedByteChannelByteSupplier(ReadableByteChannel dataChannel) {
        this(dataChannel, 8192);
    }

    @Override
    public ByteChunk get() throws ByteSupplierException {
        try {
            this.buffer.clear();
            int i = this.dataChannel.read(this.buffer);
            if (i == -1) {
                return null;
            }
            byte[] data = new byte[i];
            this.buffer.flip().get(data);
            return new ByteChunk(data);
        }
        catch (IOException e) {
            throw new ByteSupplierException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.dataChannel.close();
    }
}

