/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.bytes.consumer;

import cool.scx.bytes.ByteChunk;
import cool.scx.bytes.consumer.ByteConsumer;

public final class FillByteArrayByteConsumer
implements ByteConsumer<RuntimeException> {
    private final byte[] data;
    private final int position;
    private final int length;
    private int filledLength;

    public FillByteArrayByteConsumer(byte[] data) {
        this(data, 0, data.length);
    }

    public FillByteArrayByteConsumer(byte[] data, int position, int length) {
        this.data = data;
        this.position = position;
        this.length = length;
        this.filledLength = 0;
    }

    @Override
    public boolean accept(ByteChunk byteChunk) {
        if (this.filledLength + byteChunk.length > this.length) {
            throw new IndexOutOfBoundsException("Buffer overflow: not enough space to accept more data");
        }
        System.arraycopy(byteChunk.bytes, byteChunk.start, this.data, this.position + this.filledLength, byteChunk.length);
        this.filledLength += byteChunk.length;
        return true;
    }

    public int filledLength() {
        return this.filledLength;
    }
}

