/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.bytes;

import cool.scx.bytes.consumer.ByteArrayByteConsumer;
import cool.scx.bytes.consumer.ByteConsumer;
import cool.scx.bytes.consumer.SkipByteConsumer;
import cool.scx.bytes.exception.ByteSupplierException;
import cool.scx.bytes.exception.NoMatchFoundException;
import cool.scx.bytes.exception.NoMoreDataException;
import cool.scx.bytes.indexer.ByteIndexer;
import cool.scx.bytes.indexer.KMPByteIndexer;
import cool.scx.bytes.indexer.SingleByteIndexer;
import java.io.IOException;
import java.io.OutputStream;

public interface IByteReader
extends AutoCloseable {
    public byte read() throws NoMoreDataException, ByteSupplierException;

    public <X extends Throwable> void read(ByteConsumer<X> var1, long var2, long var4) throws NoMoreDataException, ByteSupplierException, X;

    public byte peek() throws NoMoreDataException, ByteSupplierException;

    public <X extends Throwable> void peek(ByteConsumer<X> var1, long var2, long var4) throws NoMoreDataException, ByteSupplierException, X;

    public long indexOf(ByteIndexer var1, long var2, long var4) throws NoMatchFoundException, NoMoreDataException, ByteSupplierException;

    public void mark();

    public void reset();

    public int inputStreamRead() throws IOException;

    public int inputStreamRead(byte[] var1, int var2, int var3) throws IOException;

    public long inputStreamTransferTo(OutputStream var1, long var2) throws IOException;

    public byte[] inputStreamReadNBytes(long var1) throws IOException;

    default public byte[] read(int maxLength) throws NoMoreDataException, ByteSupplierException {
        return this.read(maxLength, Long.MAX_VALUE);
    }

    default public byte[] read(int maxLength, long maxPullCount) throws NoMoreDataException, ByteSupplierException {
        ByteArrayByteConsumer consumer = new ByteArrayByteConsumer();
        this.read(consumer, maxLength, maxPullCount);
        return consumer.bytes();
    }

    default public <X extends Throwable> void read(ByteConsumer<X> byteConsumer, long maxLength) throws NoMoreDataException, ByteSupplierException, X {
        this.read(byteConsumer, maxLength, Long.MAX_VALUE);
    }

    default public byte[] peek(int maxLength) throws NoMoreDataException, ByteSupplierException {
        return this.peek(maxLength, Long.MAX_VALUE);
    }

    default public byte[] peek(int maxLength, long maxPullCount) throws NoMoreDataException, ByteSupplierException {
        ByteArrayByteConsumer consumer = new ByteArrayByteConsumer();
        this.peek(consumer, maxLength, maxPullCount);
        return consumer.bytes();
    }

    default public <X extends Throwable> void peek(ByteConsumer<X> byteConsumer, long maxLength) throws NoMoreDataException, ByteSupplierException, X {
        this.peek(byteConsumer, maxLength, Long.MAX_VALUE);
    }

    default public void skip(long length) throws NoMoreDataException, ByteSupplierException {
        this.skip(length, Long.MAX_VALUE);
    }

    default public void skip(long length, long maxPullCount) throws NoMoreDataException, ByteSupplierException {
        this.read(SkipByteConsumer.SKIP_BYTE_CONSUMER, length, maxPullCount);
    }

    default public long indexOf(byte b) throws NoMatchFoundException, NoMoreDataException, ByteSupplierException {
        return this.indexOf(b, Long.MAX_VALUE);
    }

    default public long indexOf(byte b, long maxLength) throws NoMatchFoundException, NoMoreDataException, ByteSupplierException {
        return this.indexOf(b, maxLength, Long.MAX_VALUE);
    }

    default public long indexOf(byte b, long maxLength, long maxPullCount) throws NoMatchFoundException, NoMoreDataException, ByteSupplierException {
        return this.indexOf(new SingleByteIndexer(b), maxLength, maxPullCount);
    }

    default public long indexOf(byte[] b) throws NoMatchFoundException, NoMoreDataException, ByteSupplierException {
        return this.indexOf(b, Long.MAX_VALUE);
    }

    default public long indexOf(byte[] b, long maxLength) throws NoMatchFoundException, NoMoreDataException, ByteSupplierException {
        return this.indexOf(b, maxLength, Long.MAX_VALUE);
    }

    default public long indexOf(byte[] b, long maxLength, long maxPullCount) throws NoMatchFoundException, NoMoreDataException, ByteSupplierException {
        return this.indexOf(new KMPByteIndexer(b), maxLength, maxPullCount);
    }

    default public byte[] readUntil(byte b) throws NoMatchFoundException, NoMoreDataException, ByteSupplierException {
        long index = this.indexOf(b);
        byte[] bytes = this.read(Math.toIntExact(index));
        this.skip(1L);
        return bytes;
    }

    default public byte[] readUntil(byte b, int maxLength) throws NoMatchFoundException, NoMoreDataException, ByteSupplierException {
        long index = this.indexOf(b, (long)maxLength);
        byte[] bytes = this.read(Math.toIntExact(index));
        this.skip(1L);
        return bytes;
    }

    default public byte[] readUntil(byte[] b) throws NoMatchFoundException, NoMoreDataException, ByteSupplierException {
        long index = this.indexOf(b);
        byte[] bytes = this.read(Math.toIntExact(index));
        this.skip(b.length);
        return bytes;
    }

    default public byte[] readUntil(byte[] b, int maxLength) throws NoMatchFoundException, NoMoreDataException, ByteSupplierException {
        long index = this.indexOf(b, (long)maxLength);
        byte[] bytes = this.read(Math.toIntExact(index));
        this.skip(b.length);
        return bytes;
    }

    default public byte[] peekUntil(byte b) throws NoMatchFoundException, NoMoreDataException, ByteSupplierException {
        long index = this.indexOf(b);
        return this.peek(Math.toIntExact(index));
    }

    default public byte[] peekUntil(byte b, int maxLength) throws NoMatchFoundException, NoMoreDataException, ByteSupplierException {
        long index = this.indexOf(b, (long)maxLength);
        return this.peek(Math.toIntExact(index));
    }

    default public byte[] peekUntil(byte[] b) throws NoMatchFoundException, NoMoreDataException, ByteSupplierException {
        long index = this.indexOf(b);
        return this.peek(Math.toIntExact(index));
    }

    default public byte[] peekUntil(byte[] b, int maxLength) throws NoMatchFoundException, NoMoreDataException, ByteSupplierException {
        long index = this.indexOf(b, (long)maxLength);
        return this.peek(Math.toIntExact(index));
    }

    default public long inputStreamTransferTo(OutputStream out) throws IOException {
        return this.inputStreamTransferTo(out, Long.MAX_VALUE);
    }

    @Override
    default public void close() throws IOException {
    }
}

