/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.codec.huffman;

import cool.scx.codec.huffman.HuffmanHelper;
import cool.scx.codec.huffman.HuffmanNode;
import cool.scx.collections.bit_array.BitArrayView;
import cool.scx.collections.bit_array.IBitArray;
import cool.scx.collections.count_map.CountMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

public class HuffmanCodec<T> {
    private final HuffmanNode<T> root;
    private final Map<T, IBitArray> huffmanCode;

    public HuffmanCodec(T[] data) {
        CountMap<T> map = HuffmanHelper.buildCountMap(data);
        PriorityQueue<HuffmanNode<T>> queue = HuffmanHelper.buildPriorityQueue(map);
        this.root = HuffmanHelper.buildHuffmanTree(queue);
        this.huffmanCode = HuffmanHelper.buildHuffmanCodeTable(this.root);
    }

    public HuffmanCodec(Map<T, String> huffmanCode) {
        this.huffmanCode = HuffmanHelper.normalHuffmanCode(huffmanCode);
        this.root = HuffmanHelper.buildHuffmanTreeFromCode(this.huffmanCode);
    }

    public IBitArray encode(T symbol) {
        IBitArray result = this.huffmanCode.get(symbol);
        if (result == null) {
            throw new IllegalArgumentException("Symbol " + String.valueOf(symbol) + " not found");
        }
        return result;
    }

    public IBitArray encode(List<T> data) {
        IBitArray[] paths = new IBitArray[data.size()];
        int i = 0;
        for (T symbol : data) {
            paths[i] = this.encode(symbol);
            ++i;
        }
        return new BitArrayView(paths);
    }

    public IBitArray encode(T[] data) {
        IBitArray[] paths = new IBitArray[data.length];
        int i = 0;
        for (T symbol : data) {
            paths[i] = this.encode(symbol);
            ++i;
        }
        return new BitArrayView(paths);
    }

    public T decodeSingle(IBitArray path) {
        HuffmanNode<T> current = this.root;
        for (int i = 0; i < path.length(); ++i) {
            if (current == null) {
                throw new IllegalStateException("Invalid Huffman code path: reached a null node.");
            }
            current = path.get(i) ? current.right : current.left;
        }
        if (current == null || !current.isLeaf()) {
            throw new IllegalStateException("Invalid Huffman code path: did not reach a leaf node.");
        }
        return current.value;
    }

    public List<T> decode(IBitArray path) {
        ArrayList list = new ArrayList();
        HuffmanNode<T> current = this.root;
        for (Boolean b : path) {
            if (current == null) {
                throw new IllegalStateException("Invalid Huffman code path: reached a null node.");
            }
            current = b != false ? current.right : current.left;
            if (!current.isLeaf()) continue;
            list.add(current.value);
            current = this.root;
        }
        if (current != this.root) {
            throw new IllegalStateException("Invalid Huffman code path: leftover bits.");
        }
        return list;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HuffmanCodec:\n");
        sb.append("\u7f16\u7801\u8868:\n");
        this.huffmanCode.forEach((key, value) -> sb.append(key).append(" -> ").append(value.toBinaryString()).append("\n"));
        sb.append("\u970d\u592b\u66fc\u6811:\n");
        HuffmanHelper.buildTreeString(this.root, sb, "");
        return sb.toString();
    }
}

