/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.codec.bit_array;

import cool.scx.codec.bit_array.BitArrayHelper;
import cool.scx.codec.bit_array.IBitArray;
import java.util.Arrays;

public class BitArray
implements IBitArray {
    private byte[] bytes;
    private int length;

    public BitArray() {
        this.bytes = new byte[0];
        this.length = 0;
    }

    public BitArray(int length) {
        this.bytes = new byte[BitArrayHelper.byteLength(length)];
        this.length = length;
    }

    public BitArray(byte[] bytes) {
        this.bytes = bytes;
        this.length = BitArrayHelper.byteCapacity(this.bytes);
    }

    public BitArray(byte[] bytes, int length) {
        if (length > BitArrayHelper.byteCapacity(bytes)) {
            throw new IllegalArgumentException("length \u4e0d\u5e94\u8be5\u5927\u4e8e\u603b\u5bb9\u91cf capacity");
        }
        this.bytes = bytes;
        this.length = length;
    }

    public BitArray(String binaryString) {
        this();
        BitArrayHelper.setByBinaryString(this, binaryString);
    }

    public BitArray(BitArray old) {
        this.bytes = Arrays.copyOf(old.bytes, old.bytes.length);
        this.length = old.length;
    }

    public BitArray(BitArray old, int length) {
        if (length > BitArrayHelper.byteCapacity(old.bytes)) {
            throw new IllegalArgumentException("length \u4e0d\u5e94\u8be5\u5927\u4e8e\u603b\u5bb9\u91cf capacity");
        }
        this.bytes = Arrays.copyOf(old.bytes, BitArrayHelper.byteLength(length));
        this.length = length;
    }

    @Override
    public void set(int index, boolean value) {
        this._checkIndex(index);
        this._set0(index, value);
    }

    @Override
    public void set(int fromIndex, int toIndex, boolean value) throws IndexOutOfBoundsException {
        this._checkIndex(fromIndex, toIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            this._set0(i, value);
        }
    }

    @Override
    public boolean get(int index) {
        this._checkIndex(index);
        return this._get0(index);
    }

    @Override
    public IBitArray get(int fromIndex, int toIndex) throws IndexOutOfBoundsException {
        this._checkIndex(fromIndex, toIndex);
        BitArray result = new BitArray(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.set(i - fromIndex, this._get0(i));
        }
        return result;
    }

    @Override
    public void length(int length) {
        this._ensureCapacity(length);
        this.length = length;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public byte[] toBytes() {
        int actualByteLength = BitArrayHelper.byteLength(this.length);
        return Arrays.copyOf(this.bytes, actualByteLength);
    }

    @Override
    public String toBinaryString() {
        StringBuilder sb = new StringBuilder(this.length);
        for (int i = 0; i < this.length; ++i) {
            sb.append(this._get0(i) ? (char)'1' : '0');
        }
        return sb.toString();
    }

    @Override
    public void append(boolean value) {
        this._ensureCapacity(this.length);
        this._append0(value);
    }

    @Override
    public void append(IBitArray other) {
        int otherLength = other.length();
        this._ensureCapacity(this.length + otherLength);
        for (int i = 0; i < otherLength; ++i) {
            this._append0(other.get(i));
        }
    }

    private void _checkIndex(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException("\u7d22\u5f15 " + index + " \u8d85\u51fa\u8303\u56f4, \u957f\u5ea6\u4e3a " + this.length);
        }
    }

    private void _checkIndex(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.length || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("\u7d22\u5f15\u8303\u56f4 (" + fromIndex + ", " + toIndex + ") \u8d85\u51fa\u8303\u56f4, \u957f\u5ea6\u4e3a " + this.length);
        }
    }

    private void _set0(int index, boolean value) {
        int byteIndex = BitArrayHelper.byteIndex(index);
        int bitIndex = BitArrayHelper.bitIndex(index);
        if (value) {
            int n = byteIndex;
            this.bytes[n] = (byte)(this.bytes[n] | BitArrayHelper.BIT_MASKS[bitIndex]);
        } else {
            int n = byteIndex;
            this.bytes[n] = (byte)(this.bytes[n] & (byte)(~BitArrayHelper.BIT_MASKS[bitIndex]));
        }
    }

    private boolean _get0(int index) {
        int bitIndex;
        int byteIndex = BitArrayHelper.byteIndex(index);
        return (this.bytes[byteIndex] & BitArrayHelper.BIT_MASKS[bitIndex = BitArrayHelper.bitIndex(index)]) != 0;
    }

    private void _append0(boolean value) {
        this._set0(this.length, value);
        ++this.length;
    }

    private void _ensureCapacity(int index) {
        if (index >= BitArrayHelper.byteCapacity(this.bytes)) {
            int newByteSize = Math.max(BitArrayHelper.byteLength(index + 1), this.bytes.length << 1);
            this.bytes = Arrays.copyOf(this.bytes, newByteSize);
        }
    }
}

