/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.collections.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator<T>
implements Iterator<T>,
Iterable<T> {
    private final T[] array;
    private int index;

    public ArrayIterator(T[] array) {
        this.array = array;
        this.index = 0;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.array.length;
    }

    @Override
    public T next() {
        if (this.index >= this.array.length) {
            throw new NoSuchElementException("No more elements.");
        }
        T n = this.array[this.index];
        this.array[this.index] = null;
        ++this.index;
        return n;
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }
}

