/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.collections.circular_linked_list;

import cool.scx.collections.circular_linked_list.CircularLinkedIterator;
import cool.scx.collections.circular_linked_list.ICircularLinkedList;
import cool.scx.collections.circular_linked_list.Node;
import cool.scx.collections.circular_linked_list.ReverseCircularLinkedList;
import java.util.Objects;
import java.util.function.IntFunction;

public final class CircularLinkedList<T>
implements ICircularLinkedList<T> {
    private Node<T> first;
    private Node<T> last;
    private int size;

    @Override
    public T first() {
        return (T)this.first.item;
    }

    @Override
    public T last() {
        return (T)this.last.item;
    }

    @Override
    public Node<T> firstNode() {
        return this.first;
    }

    @Override
    public Node<T> lastNode() {
        return this.last;
    }

    @Override
    public int size() {
        return this.size;
    }

    private void link(Node<T> node) {
        node.prev = this.last;
        node.next = this.first;
        this.last.next = node;
        this.first.prev = node;
        this.last = node;
    }

    private T unlink(Node<T> node) {
        Node prev;
        Object item = node.item;
        Node next = node.next;
        next.prev = prev = node.prev;
        prev.next = next;
        if (node == this.first) {
            this.first = next;
        }
        if (node == this.last) {
            this.last = prev;
        }
        node.next = null;
        node.prev = null;
        node.item = null;
        return (T)item;
    }

    @Override
    public boolean add(T item) {
        Node<T> node = new Node<T>(item);
        if (this.last == null) {
            node.next = node;
            node.prev = node.next;
            this.last = node.next;
            this.first = node.next;
        } else {
            this.link(node);
        }
        ++this.size;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        Node<T> node = this.node(o);
        if (node == null) {
            return false;
        }
        this.unlink(node);
        --this.size;
        if (this.size == 0) {
            this.last = null;
            this.first = null;
        }
        return true;
    }

    @Override
    public void clear() {
        Node<Object> x = this.first;
        while (x != null) {
            Node next = x.next;
            x.item = null;
            x.next = null;
            x.prev = null;
            x = next;
        }
        this.last = null;
        this.first = null;
        this.size = 0;
    }

    @Override
    public Node<T> node(Object o) {
        if (this.first == null) {
            return null;
        }
        Node<Object> x = this.first;
        do {
            if (!Objects.equals(o, x.item)) continue;
            return x;
        } while ((x = x.next) != this.first);
        return null;
    }

    @Override
    public CircularLinkedIterator<T> iterator() {
        return new CircularLinkedIterator<T>(this.first);
    }

    private void fillArray(Object[] arr) {
        int i = 0;
        Node<Object> x = this.first;
        do {
            arr[i] = x.item;
            ++i;
        } while ((x = x.next) != this.first);
    }

    @Override
    public Object[] toArray() {
        Object[] arr = new Object[this.size];
        this.fillArray(arr);
        return arr;
    }

    @Override
    public T[] toArray(IntFunction<T[]> generator) {
        Object[] arr = generator.apply(this.size);
        this.fillArray(arr);
        return arr;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        Node<T> node = this.node(o);
        return node != null;
    }

    @Override
    public ICircularLinkedList<T> reversed() {
        return new ReverseCircularLinkedList(this);
    }
}

