/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.collections.circular_linked_list;

import cool.scx.collections.circular_linked_list.CircularLinkedIterator;
import cool.scx.collections.circular_linked_list.CircularLinkedList;
import cool.scx.collections.circular_linked_list.ICircularLinkedIterator;
import cool.scx.collections.circular_linked_list.ICircularLinkedList;
import cool.scx.collections.circular_linked_list.Node;
import cool.scx.collections.circular_linked_list.ReverseCircularLinkedIterator;
import java.util.function.IntFunction;

final class ReverseCircularLinkedList<T>
implements ICircularLinkedList<T> {
    private final CircularLinkedList<T> circularLinkedList;

    public ReverseCircularLinkedList(CircularLinkedList<T> circularLinkedList) {
        this.circularLinkedList = circularLinkedList;
    }

    @Override
    public T first() {
        return this.circularLinkedList.last();
    }

    @Override
    public T last() {
        return this.circularLinkedList.first();
    }

    @Override
    public Node<T> firstNode() {
        return this.circularLinkedList.lastNode();
    }

    @Override
    public Node<T> lastNode() {
        return this.circularLinkedList.firstNode();
    }

    @Override
    public int size() {
        return this.circularLinkedList.size();
    }

    @Override
    public boolean add(T item) {
        return this.circularLinkedList.add(item);
    }

    @Override
    public boolean remove(Object o) {
        return this.circularLinkedList.remove(o);
    }

    @Override
    public void clear() {
        this.circularLinkedList.clear();
    }

    @Override
    public Node<T> node(Object o) {
        return this.circularLinkedList.node(o);
    }

    @Override
    public ICircularLinkedIterator<T> iterator() {
        return new ReverseCircularLinkedIterator<T>(new CircularLinkedIterator<T>(this.circularLinkedList.lastNode()));
    }

    @Override
    public Object[] toArray() {
        Object[] arr = new Object[this.circularLinkedList.size()];
        this.fillArray(arr);
        return arr;
    }

    @Override
    public T[] toArray(IntFunction<T[]> generator) {
        Object[] arr = generator.apply(this.circularLinkedList.size());
        this.fillArray(arr);
        return arr;
    }

    @Override
    public boolean isEmpty() {
        return this.circularLinkedList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.circularLinkedList.contains(o);
    }

    @Override
    public ICircularLinkedList<T> reversed() {
        return this.circularLinkedList;
    }

    private void fillArray(Object[] arr) {
        int i = 0;
        Node<Object> x = this.circularLinkedList.lastNode();
        do {
            arr[i] = x.item;
            ++i;
        } while ((x = x.prev) != this.circularLinkedList.lastNode());
    }
}

