/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.collections.count_map;

import cool.scx.collections.count_map.CountMapIterator;
import cool.scx.collections.count_map.ICountMap;
import cool.scx.collections.count_map.ICountMapEntry;
import cool.scx.functional.ScxObjLongConsumer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public class CountMap<K>
implements ICountMap<K> {
    private final Map<K, AtomicLong> map;

    public CountMap() {
        this(HashMap::new);
    }

    public CountMap(Supplier<Map<K, AtomicLong>> mapSupplier) {
        this.map = mapSupplier.get();
    }

    @Override
    public long add(K key, long count) {
        return this.map.computeIfAbsent(key, k -> new AtomicLong()).addAndGet(count);
    }

    @Override
    public Long set(K key, long count) {
        AtomicLong v = this.map.put(key, new AtomicLong(count));
        return v == null ? null : Long.valueOf(v.get());
    }

    @Override
    public Long get(K key) {
        AtomicLong v = this.map.get(key);
        return v == null ? null : Long.valueOf(v.get());
    }

    @Override
    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    @Override
    public Long remove(K key) {
        AtomicLong v = this.map.remove(key);
        return v == null ? null : Long.valueOf(v.get());
    }

    @Override
    public Set<K> keys() {
        return this.map.keySet();
    }

    @Override
    public long size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Map<K, Long> toMap() {
        return this.toMap(HashMap::new);
    }

    @Override
    public Map<K, Long> toMap(Supplier<Map<K, Long>> mapSupplier) {
        Map<K, Long> result = mapSupplier.get();
        for (Map.Entry<K, AtomicLong> entry : this.map.entrySet()) {
            result.put(entry.getKey(), entry.getValue().get());
        }
        return result;
    }

    @Override
    public <E extends Throwable> void forEach(ScxObjLongConsumer<? super K, E> action) throws E {
        for (Map.Entry<K, AtomicLong> entry : this.map.entrySet()) {
            K key = entry.getKey();
            long values = entry.getValue().get();
            action.accept(key, values);
        }
    }

    @Override
    public Iterator<ICountMapEntry<K>> iterator() {
        return new CountMapIterator<K>(this.map.entrySet().iterator());
    }

    public String toString() {
        return this.map.toString();
    }
}

