/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.collections;

import java.lang.reflect.Array;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;

public final class ArrayUtils {
    public static byte[] toPrimitive(Byte ... w) {
        byte[] p = new byte[w.length];
        for (int i = 0; i < w.length; ++i) {
            p[i] = w[i];
        }
        return p;
    }

    public static short[] toPrimitive(Short ... w) {
        short[] p = new short[w.length];
        for (int i = 0; i < w.length; ++i) {
            p[i] = w[i];
        }
        return p;
    }

    public static int[] toPrimitive(Integer ... w) {
        int[] p = new int[w.length];
        for (int i = 0; i < w.length; ++i) {
            p[i] = w[i];
        }
        return p;
    }

    public static long[] toPrimitive(Long ... w) {
        long[] p = new long[w.length];
        for (int i = 0; i < w.length; ++i) {
            p[i] = w[i];
        }
        return p;
    }

    public static float[] toPrimitive(Float ... w) {
        float[] p = new float[w.length];
        for (int i = 0; i < w.length; ++i) {
            p[i] = w[i].floatValue();
        }
        return p;
    }

    public static double[] toPrimitive(Double ... w) {
        double[] p = new double[w.length];
        for (int i = 0; i < w.length; ++i) {
            p[i] = w[i];
        }
        return p;
    }

    public static boolean[] toPrimitive(Boolean ... w) {
        boolean[] p = new boolean[w.length];
        for (int i = 0; i < w.length; ++i) {
            p[i] = w[i];
        }
        return p;
    }

    public static char[] toPrimitive(Character ... w) {
        char[] p = new char[w.length];
        for (int i = 0; i < w.length; ++i) {
            p[i] = w[i].charValue();
        }
        return p;
    }

    public static Byte[] toWrapper(byte ... p) {
        Byte[] w = new Byte[p.length];
        for (int i = 0; i < p.length; ++i) {
            w[i] = p[i];
        }
        return w;
    }

    public static Short[] toWrapper(short ... p) {
        Short[] w = new Short[p.length];
        for (int i = 0; i < p.length; ++i) {
            w[i] = p[i];
        }
        return w;
    }

    public static Integer[] toWrapper(int ... p) {
        Integer[] w = new Integer[p.length];
        for (int i = 0; i < p.length; ++i) {
            w[i] = p[i];
        }
        return w;
    }

    public static Long[] toWrapper(long ... p) {
        Long[] w = new Long[p.length];
        for (int i = 0; i < p.length; ++i) {
            w[i] = p[i];
        }
        return w;
    }

    public static Float[] toWrapper(float ... p) {
        Float[] w = new Float[p.length];
        for (int i = 0; i < p.length; ++i) {
            w[i] = Float.valueOf(p[i]);
        }
        return w;
    }

    public static Double[] toWrapper(double ... p) {
        Double[] w = new Double[p.length];
        for (int i = 0; i < p.length; ++i) {
            w[i] = p[i];
        }
        return w;
    }

    public static Boolean[] toWrapper(boolean ... p) {
        Boolean[] w = new Boolean[p.length];
        for (int i = 0; i < p.length; ++i) {
            w[i] = p[i];
        }
        return w;
    }

    public static Character[] toWrapper(char ... p) {
        Character[] w = new Character[p.length];
        for (int i = 0; i < p.length; ++i) {
            w[i] = Character.valueOf(p[i]);
        }
        return w;
    }

    public static void swap(byte[] arr, int i, int j) {
        byte tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    public static void swap(short[] arr, int i, int j) {
        short tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    public static void swap(int[] arr, int i, int j) {
        int tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    public static void swap(long[] arr, int i, int j) {
        long tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    public static void swap(float[] arr, int i, int j) {
        float tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    public static void swap(double[] arr, int i, int j) {
        double tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    public static void swap(boolean[] arr, int i, int j) {
        boolean tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    public static void swap(char[] arr, int i, int j) {
        char tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    public static void swap(Object[] arr, int i, int j) {
        Object tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    private static int randomInt(int bound) {
        return ThreadLocalRandom.current().nextInt(bound);
    }

    public static void shuffle(byte ... arr) {
        for (int i = arr.length; i > 1; --i) {
            ArrayUtils.swap(arr, i - 1, ArrayUtils.randomInt(i));
        }
    }

    public static void shuffle(short ... arr) {
        for (int i = arr.length; i > 1; --i) {
            ArrayUtils.swap(arr, i - 1, ArrayUtils.randomInt(i));
        }
    }

    public static void shuffle(int ... arr) {
        for (int i = arr.length; i > 1; --i) {
            ArrayUtils.swap(arr, i - 1, ArrayUtils.randomInt(i));
        }
    }

    public static void shuffle(long ... arr) {
        for (int i = arr.length; i > 1; --i) {
            ArrayUtils.swap(arr, i - 1, ArrayUtils.randomInt(i));
        }
    }

    public static void shuffle(float ... arr) {
        for (int i = arr.length; i > 1; --i) {
            ArrayUtils.swap(arr, i - 1, ArrayUtils.randomInt(i));
        }
    }

    public static void shuffle(double ... arr) {
        for (int i = arr.length; i > 1; --i) {
            ArrayUtils.swap(arr, i - 1, ArrayUtils.randomInt(i));
        }
    }

    public static void shuffle(boolean ... arr) {
        for (int i = arr.length; i > 1; --i) {
            ArrayUtils.swap(arr, i - 1, ArrayUtils.randomInt(i));
        }
    }

    public static void shuffle(char ... arr) {
        for (int i = arr.length; i > 1; --i) {
            ArrayUtils.swap(arr, i - 1, ArrayUtils.randomInt(i));
        }
    }

    public static void shuffle(Object ... arr) {
        for (int i = arr.length; i > 1; --i) {
            ArrayUtils.swap(arr, i - 1, ArrayUtils.randomInt(i));
        }
    }

    public static void reverse(byte ... arr) {
        int mid = arr.length / 2;
        for (int i = 0; i < mid; ++i) {
            ArrayUtils.swap(arr, i, arr.length - i - 1);
        }
    }

    public static void reverse(short ... arr) {
        int mid = arr.length / 2;
        for (int i = 0; i < mid; ++i) {
            ArrayUtils.swap(arr, i, arr.length - i - 1);
        }
    }

    public static void reverse(int ... arr) {
        int mid = arr.length / 2;
        for (int i = 0; i < mid; ++i) {
            ArrayUtils.swap(arr, i, arr.length - i - 1);
        }
    }

    public static void reverse(long ... arr) {
        int mid = arr.length / 2;
        for (int i = 0; i < mid; ++i) {
            ArrayUtils.swap(arr, i, arr.length - i - 1);
        }
    }

    public static void reverse(float ... arr) {
        int mid = arr.length / 2;
        for (int i = 0; i < mid; ++i) {
            ArrayUtils.swap(arr, i, arr.length - i - 1);
        }
    }

    public static void reverse(double ... arr) {
        int mid = arr.length / 2;
        for (int i = 0; i < mid; ++i) {
            ArrayUtils.swap(arr, i, arr.length - i - 1);
        }
    }

    public static void reverse(boolean ... arr) {
        int mid = arr.length / 2;
        for (int i = 0; i < mid; ++i) {
            ArrayUtils.swap(arr, i, arr.length - i - 1);
        }
    }

    public static void reverse(char ... arr) {
        int mid = arr.length / 2;
        for (int i = 0; i < mid; ++i) {
            ArrayUtils.swap(arr, i, arr.length - i - 1);
        }
    }

    public static void reverse(Object ... arr) {
        int mid = arr.length / 2;
        for (int i = 0; i < mid; ++i) {
            ArrayUtils.swap(arr, i, arr.length - i - 1);
        }
    }

    public static int indexOf(byte[] a, int startPosition, int maxLength, byte ... b) {
        int endIndex = Math.min(a.length, startPosition + maxLength) - b.length;
        for (int i = startPosition; i <= endIndex; ++i) {
            boolean found = true;
            for (int j = 0; j < b.length; ++j) {
                if (a[i + j] == b[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(short[] a, int startPosition, int maxLength, short ... b) {
        int endIndex = Math.min(a.length, startPosition + maxLength) - b.length;
        for (int i = startPosition; i <= endIndex; ++i) {
            boolean found = true;
            for (int j = 0; j < b.length; ++j) {
                if (a[i + j] == b[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int[] a, int startPosition, int maxLength, int ... b) {
        int endIndex = Math.min(a.length, startPosition + maxLength) - b.length;
        for (int i = startPosition; i <= endIndex; ++i) {
            boolean found = true;
            for (int j = 0; j < b.length; ++j) {
                if (a[i + j] == b[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(long[] a, int startPosition, int maxLength, long ... b) {
        int endIndex = Math.min(a.length, startPosition + maxLength) - b.length;
        for (int i = startPosition; i <= endIndex; ++i) {
            boolean found = true;
            for (int j = 0; j < b.length; ++j) {
                if (a[i + j] == b[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(float[] a, int startPosition, int maxLength, float ... b) {
        int endIndex = Math.min(a.length, startPosition + maxLength) - b.length;
        for (int i = startPosition; i <= endIndex; ++i) {
            boolean found = true;
            for (int j = 0; j < b.length; ++j) {
                if (a[i + j] == b[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(double[] a, int startPosition, int maxLength, double ... b) {
        int endIndex = Math.min(a.length, startPosition + maxLength) - b.length;
        for (int i = startPosition; i <= endIndex; ++i) {
            boolean found = true;
            for (int j = 0; j < b.length; ++j) {
                if (a[i + j] == b[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(boolean[] a, int startPosition, int maxLength, boolean ... b) {
        int endIndex = Math.min(a.length, startPosition + maxLength) - b.length;
        for (int i = startPosition; i <= endIndex; ++i) {
            boolean found = true;
            for (int j = 0; j < b.length; ++j) {
                if (a[i + j] == b[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(char[] a, int startPosition, int maxLength, char ... b) {
        int endIndex = Math.min(a.length, startPosition + maxLength) - b.length;
        for (int i = startPosition; i <= endIndex; ++i) {
            boolean found = true;
            for (int j = 0; j < b.length; ++j) {
                if (a[i + j] == b[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(Object[] a, int startPosition, int maxLength, Object ... b) {
        int endIndex = Math.min(a.length, startPosition + maxLength) - b.length;
        for (int i = startPosition; i <= endIndex; ++i) {
            boolean found = true;
            for (int j = 0; j < b.length; ++j) {
                if (Objects.equals(a[i + j], b[j])) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(byte[] a, byte ... b) {
        return ArrayUtils.indexOf(a, 0, a.length, b);
    }

    public static int indexOf(short[] a, short ... b) {
        return ArrayUtils.indexOf(a, 0, a.length, b);
    }

    public static int indexOf(int[] a, int ... b) {
        return ArrayUtils.indexOf(a, 0, a.length, b);
    }

    public static int indexOf(long[] a, long ... b) {
        return ArrayUtils.indexOf(a, 0, a.length, b);
    }

    public static int indexOf(float[] a, float ... b) {
        return ArrayUtils.indexOf(a, 0, a.length, b);
    }

    public static int indexOf(double[] a, double ... b) {
        return ArrayUtils.indexOf(a, 0, a.length, b);
    }

    public static int indexOf(boolean[] a, boolean ... b) {
        return ArrayUtils.indexOf(a, 0, a.length, b);
    }

    public static int indexOf(char[] a, char ... b) {
        return ArrayUtils.indexOf(a, 0, a.length, b);
    }

    public static int indexOf(Object[] a, Object ... b) {
        return ArrayUtils.indexOf(a, 0, a.length, b);
    }

    public static int indexOf(byte[] a, int startPosition, int maxLength, byte b) {
        int endIndex = Math.min(a.length, startPosition + maxLength);
        for (int i = startPosition; i < endIndex; ++i) {
            if (a[i] != b) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(short[] a, int startPosition, int maxLength, short b) {
        int endIndex = Math.min(a.length, startPosition + maxLength);
        for (int i = startPosition; i < endIndex; ++i) {
            if (a[i] != b) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int[] a, int startPosition, int maxLength, int b) {
        int endIndex = Math.min(a.length, startPosition + maxLength);
        for (int i = startPosition; i < endIndex; ++i) {
            if (a[i] != b) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(long[] a, int startPosition, int maxLength, long b) {
        int endIndex = Math.min(a.length, startPosition + maxLength);
        for (int i = startPosition; i < endIndex; ++i) {
            if (a[i] != b) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(float[] a, int startPosition, int maxLength, float b) {
        int endIndex = Math.min(a.length, startPosition + maxLength);
        for (int i = startPosition; i < endIndex; ++i) {
            if (a[i] != b) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(double[] a, int startPosition, int maxLength, double b) {
        int endIndex = Math.min(a.length, startPosition + maxLength);
        for (int i = startPosition; i < endIndex; ++i) {
            if (a[i] != b) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(boolean[] a, int startPosition, int maxLength, boolean b) {
        int endIndex = Math.min(a.length, startPosition + maxLength);
        for (int i = startPosition; i < endIndex; ++i) {
            if (a[i] != b) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(char[] a, int startPosition, int maxLength, char b) {
        int endIndex = Math.min(a.length, startPosition + maxLength);
        for (int i = startPosition; i < endIndex; ++i) {
            if (a[i] != b) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(Object[] a, int startPosition, int maxLength, Object b) {
        int endIndex = Math.min(a.length, startPosition + maxLength);
        for (int i = startPosition; i < endIndex; ++i) {
            if (!Objects.equals(a[i], b)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(byte[] a, byte b) {
        return ArrayUtils.indexOf(a, 0, a.length, b);
    }

    public static int indexOf(short[] a, short b) {
        return ArrayUtils.indexOf(a, 0, a.length, b);
    }

    public static int indexOf(int[] a, int b) {
        return ArrayUtils.indexOf(a, 0, a.length, b);
    }

    public static int indexOf(long[] a, long b) {
        return ArrayUtils.indexOf(a, 0, a.length, b);
    }

    public static int indexOf(float[] a, float b) {
        return ArrayUtils.indexOf(a, 0, a.length, b);
    }

    public static int indexOf(double[] a, double b) {
        return ArrayUtils.indexOf(a, 0, a.length, b);
    }

    public static int indexOf(boolean[] a, boolean b) {
        return ArrayUtils.indexOf(a, 0, a.length, b);
    }

    public static int indexOf(char[] a, char b) {
        return ArrayUtils.indexOf(a, 0, a.length, b);
    }

    public static int indexOf(Object[] a, Object b) {
        return ArrayUtils.indexOf(a, 0, a.length, b);
    }

    public static byte[] concat(byte[] ... arrays) {
        int totalLength = 0;
        for (byte[] arr : arrays) {
            if (arr == null) continue;
            totalLength += arr.length;
        }
        byte[] result = new byte[totalLength];
        int pos = 0;
        for (byte[] arr : arrays) {
            if (arr == null) continue;
            System.arraycopy(arr, 0, result, pos, arr.length);
            pos += arr.length;
        }
        return result;
    }

    public static short[] concat(short[] ... arrays) {
        int totalLength = 0;
        for (short[] arr : arrays) {
            if (arr == null) continue;
            totalLength += arr.length;
        }
        short[] result = new short[totalLength];
        int pos = 0;
        for (short[] arr : arrays) {
            if (arr == null) continue;
            System.arraycopy(arr, 0, result, pos, arr.length);
            pos += arr.length;
        }
        return result;
    }

    public static int[] concat(int[] ... arrays) {
        int totalLength = 0;
        for (int[] arr : arrays) {
            if (arr == null) continue;
            totalLength += arr.length;
        }
        int[] result = new int[totalLength];
        int pos = 0;
        for (int[] arr : arrays) {
            if (arr == null) continue;
            System.arraycopy(arr, 0, result, pos, arr.length);
            pos += arr.length;
        }
        return result;
    }

    public static long[] concat(long[] ... arrays) {
        int totalLength = 0;
        for (long[] arr : arrays) {
            if (arr == null) continue;
            totalLength += arr.length;
        }
        long[] result = new long[totalLength];
        int pos = 0;
        for (long[] arr : arrays) {
            if (arr == null) continue;
            System.arraycopy(arr, 0, result, pos, arr.length);
            pos += arr.length;
        }
        return result;
    }

    public static float[] concat(float[] ... arrays) {
        int totalLength = 0;
        for (float[] arr : arrays) {
            if (arr == null) continue;
            totalLength += arr.length;
        }
        float[] result = new float[totalLength];
        int pos = 0;
        for (float[] arr : arrays) {
            if (arr == null) continue;
            System.arraycopy(arr, 0, result, pos, arr.length);
            pos += arr.length;
        }
        return result;
    }

    public static double[] concat(double[] ... arrays) {
        int totalLength = 0;
        for (double[] arr : arrays) {
            if (arr == null) continue;
            totalLength += arr.length;
        }
        double[] result = new double[totalLength];
        int pos = 0;
        for (double[] arr : arrays) {
            if (arr == null) continue;
            System.arraycopy(arr, 0, result, pos, arr.length);
            pos += arr.length;
        }
        return result;
    }

    public static boolean[] concat(boolean[] ... arrays) {
        int totalLength = 0;
        for (boolean[] arr : arrays) {
            if (arr == null) continue;
            totalLength += arr.length;
        }
        boolean[] result = new boolean[totalLength];
        int pos = 0;
        for (boolean[] arr : arrays) {
            if (arr == null) continue;
            System.arraycopy(arr, 0, result, pos, arr.length);
            pos += arr.length;
        }
        return result;
    }

    public static char[] concat(char[] ... arrays) {
        int totalLength = 0;
        for (char[] arr : arrays) {
            if (arr == null) continue;
            totalLength += arr.length;
        }
        char[] result = new char[totalLength];
        int pos = 0;
        for (char[] arr : arrays) {
            if (arr == null) continue;
            System.arraycopy(arr, 0, result, pos, arr.length);
            pos += arr.length;
        }
        return result;
    }

    public static <T> T[] concat(T[] ... arrays) {
        int totalLength = 0;
        for (T[] arr : arrays) {
            if (arr == null) continue;
            totalLength += arr.length;
        }
        Object[] result = (Object[])Array.newInstance(((Class)arrays.getClass().componentType()).componentType(), totalLength);
        int pos = 0;
        for (T[] arr : arrays) {
            if (arr == null) continue;
            System.arraycopy(arr, 0, result, pos, arr.length);
            pos += arr.length;
        }
        return result;
    }

    private static int numOfSlices(int length, int n) {
        return (length + n - 1) / n;
    }

    public static byte[][] splitArray(byte[] arr, int sliceSize) {
        int numOfSlices = ArrayUtils.numOfSlices(arr.length, sliceSize);
        byte[][] result = new byte[numOfSlices][];
        for (int i = 0; i < numOfSlices; ++i) {
            int start = i * sliceSize;
            int end = Math.min(start + sliceSize, arr.length);
            result[i] = Arrays.copyOfRange(arr, start, end);
        }
        return result;
    }

    public static short[][] splitArray(short[] arr, int sliceSize) {
        int numOfSlices = ArrayUtils.numOfSlices(arr.length, sliceSize);
        short[][] result = new short[numOfSlices][];
        for (int i = 0; i < numOfSlices; ++i) {
            int start = i * sliceSize;
            int end = Math.min(start + sliceSize, arr.length);
            result[i] = Arrays.copyOfRange(arr, start, end);
        }
        return result;
    }

    public static int[][] splitArray(int[] arr, int sliceSize) {
        int numOfSlices = ArrayUtils.numOfSlices(arr.length, sliceSize);
        int[][] result = new int[numOfSlices][];
        for (int i = 0; i < numOfSlices; ++i) {
            int start = i * sliceSize;
            int end = Math.min(start + sliceSize, arr.length);
            result[i] = Arrays.copyOfRange(arr, start, end);
        }
        return result;
    }

    public static long[][] splitArray(long[] arr, int sliceSize) {
        int numOfSlices = ArrayUtils.numOfSlices(arr.length, sliceSize);
        long[][] result = new long[numOfSlices][];
        for (int i = 0; i < numOfSlices; ++i) {
            int start = i * sliceSize;
            int end = Math.min(start + sliceSize, arr.length);
            result[i] = Arrays.copyOfRange(arr, start, end);
        }
        return result;
    }

    public static float[][] splitArray(float[] arr, int sliceSize) {
        int numOfSlices = ArrayUtils.numOfSlices(arr.length, sliceSize);
        float[][] result = new float[numOfSlices][];
        for (int i = 0; i < numOfSlices; ++i) {
            int start = i * sliceSize;
            int end = Math.min(start + sliceSize, arr.length);
            result[i] = Arrays.copyOfRange(arr, start, end);
        }
        return result;
    }

    public static double[][] splitArray(double[] arr, int sliceSize) {
        int numOfSlices = ArrayUtils.numOfSlices(arr.length, sliceSize);
        double[][] result = new double[numOfSlices][];
        for (int i = 0; i < numOfSlices; ++i) {
            int start = i * sliceSize;
            int end = Math.min(start + sliceSize, arr.length);
            result[i] = Arrays.copyOfRange(arr, start, end);
        }
        return result;
    }

    public static boolean[][] splitArray(boolean[] arr, int sliceSize) {
        int numOfSlices = ArrayUtils.numOfSlices(arr.length, sliceSize);
        boolean[][] result = new boolean[numOfSlices][];
        for (int i = 0; i < numOfSlices; ++i) {
            int start = i * sliceSize;
            int end = Math.min(start + sliceSize, arr.length);
            result[i] = Arrays.copyOfRange(arr, start, end);
        }
        return result;
    }

    public static char[][] splitArray(char[] arr, int sliceSize) {
        int numOfSlices = ArrayUtils.numOfSlices(arr.length, sliceSize);
        char[][] result = new char[numOfSlices][];
        for (int i = 0; i < numOfSlices; ++i) {
            int start = i * sliceSize;
            int end = Math.min(start + sliceSize, arr.length);
            result[i] = Arrays.copyOfRange(arr, start, end);
        }
        return result;
    }

    public static <T> T[][] splitArray(T[] arr, int sliceSize) {
        int numOfSlices = ArrayUtils.numOfSlices(arr.length, sliceSize);
        Object[][] result = (Object[][])Array.newInstance(arr.getClass().componentType(), new int[]{numOfSlices, 0});
        for (int i = 0; i < numOfSlices; ++i) {
            int start = i * sliceSize;
            int end = Math.min(start + sliceSize, arr.length);
            result[i] = Arrays.copyOfRange(arr, start, end);
        }
        return result;
    }

    public static byte[][] splitArrayN(byte[] arr, int n) {
        return ArrayUtils.splitArray(arr, ArrayUtils.numOfSlices(arr.length, n));
    }

    public static short[][] splitArrayN(short[] arr, int n) {
        return ArrayUtils.splitArray(arr, ArrayUtils.numOfSlices(arr.length, n));
    }

    public static int[][] splitArrayN(int[] arr, int n) {
        return ArrayUtils.splitArray(arr, ArrayUtils.numOfSlices(arr.length, n));
    }

    public static long[][] splitArrayN(long[] arr, int n) {
        return ArrayUtils.splitArray(arr, ArrayUtils.numOfSlices(arr.length, n));
    }

    public static float[][] splitArrayN(float[] arr, int n) {
        return ArrayUtils.splitArray(arr, ArrayUtils.numOfSlices(arr.length, n));
    }

    public static double[][] splitArrayN(double[] arr, int n) {
        return ArrayUtils.splitArray(arr, ArrayUtils.numOfSlices(arr.length, n));
    }

    public static boolean[][] splitArrayN(boolean[] arr, int n) {
        return ArrayUtils.splitArray(arr, ArrayUtils.numOfSlices(arr.length, n));
    }

    public static char[][] splitArrayN(char[] arr, int n) {
        return ArrayUtils.splitArray(arr, ArrayUtils.numOfSlices(arr.length, n));
    }

    public static <T> T[][] splitArrayN(T[] arr, int n) {
        return ArrayUtils.splitArray(arr, ArrayUtils.numOfSlices(arr.length, n));
    }

    public static void subArrayCheck(int fromIndex, int toIndex, int size) {
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > size) {
            throw new ArrayIndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new ArrayIndexOutOfBoundsException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
    }

    public static byte[] subArray(byte[] array, int fromIndex, int toIndex) {
        ArrayUtils.subArrayCheck(fromIndex, toIndex, array.length);
        byte[] subArray = new byte[toIndex - fromIndex];
        System.arraycopy(array, fromIndex, subArray, 0, subArray.length);
        return subArray;
    }

    public static short[] subArray(short[] array, int fromIndex, int toIndex) {
        ArrayUtils.subArrayCheck(fromIndex, toIndex, array.length);
        short[] subArray = new short[toIndex - fromIndex];
        System.arraycopy(array, fromIndex, subArray, 0, subArray.length);
        return subArray;
    }

    public static int[] subArray(int[] array, int fromIndex, int toIndex) {
        ArrayUtils.subArrayCheck(fromIndex, toIndex, array.length);
        int[] subArray = new int[toIndex - fromIndex];
        System.arraycopy(array, fromIndex, subArray, 0, subArray.length);
        return subArray;
    }

    public static long[] subArray(long[] array, int fromIndex, int toIndex) {
        ArrayUtils.subArrayCheck(fromIndex, toIndex, array.length);
        long[] subArray = new long[toIndex - fromIndex];
        System.arraycopy(array, fromIndex, subArray, 0, subArray.length);
        return subArray;
    }

    public static float[] subArray(float[] array, int fromIndex, int toIndex) {
        ArrayUtils.subArrayCheck(fromIndex, toIndex, array.length);
        float[] subArray = new float[toIndex - fromIndex];
        System.arraycopy(array, fromIndex, subArray, 0, subArray.length);
        return subArray;
    }

    public static double[] subArray(double[] array, int fromIndex, int toIndex) {
        ArrayUtils.subArrayCheck(fromIndex, toIndex, array.length);
        double[] subArray = new double[toIndex - fromIndex];
        System.arraycopy(array, fromIndex, subArray, 0, subArray.length);
        return subArray;
    }

    public static boolean[] subArray(boolean[] array, int fromIndex, int toIndex) {
        ArrayUtils.subArrayCheck(fromIndex, toIndex, array.length);
        boolean[] subArray = new boolean[toIndex - fromIndex];
        System.arraycopy(array, fromIndex, subArray, 0, subArray.length);
        return subArray;
    }

    public static char[] subArray(char[] array, int fromIndex, int toIndex) {
        ArrayUtils.subArrayCheck(fromIndex, toIndex, array.length);
        char[] subArray = new char[toIndex - fromIndex];
        System.arraycopy(array, fromIndex, subArray, 0, subArray.length);
        return subArray;
    }

    public static <T> T[] subArray(T[] array, int fromIndex, int toIndex) {
        ArrayUtils.subArrayCheck(fromIndex, toIndex, array.length);
        Object[] subArray = (Object[])Array.newInstance(array.getClass().componentType(), toIndex - fromIndex);
        System.arraycopy(array, fromIndex, subArray, 0, subArray.length);
        return subArray;
    }

    public static byte[] safeSubArray(byte[] array, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (toIndex > array.length) {
            toIndex = array.length;
        }
        if (fromIndex >= toIndex) {
            return new byte[0];
        }
        byte[] subArray = new byte[toIndex - fromIndex];
        System.arraycopy(array, fromIndex, subArray, 0, subArray.length);
        return subArray;
    }

    public static short[] safeSubArray(short[] array, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (toIndex > array.length) {
            toIndex = array.length;
        }
        if (fromIndex >= toIndex) {
            return new short[0];
        }
        short[] subArray = new short[toIndex - fromIndex];
        System.arraycopy(array, fromIndex, subArray, 0, subArray.length);
        return subArray;
    }

    public static int[] safeSubArray(int[] array, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (toIndex > array.length) {
            toIndex = array.length;
        }
        if (fromIndex >= toIndex) {
            return new int[0];
        }
        int[] subArray = new int[toIndex - fromIndex];
        System.arraycopy(array, fromIndex, subArray, 0, subArray.length);
        return subArray;
    }

    public static long[] safeSubArray(long[] array, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (toIndex > array.length) {
            toIndex = array.length;
        }
        if (fromIndex >= toIndex) {
            return new long[0];
        }
        long[] subArray = new long[toIndex - fromIndex];
        System.arraycopy(array, fromIndex, subArray, 0, subArray.length);
        return subArray;
    }

    public static float[] safeSubArray(float[] array, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (toIndex > array.length) {
            toIndex = array.length;
        }
        if (fromIndex >= toIndex) {
            return new float[0];
        }
        float[] subArray = new float[toIndex - fromIndex];
        System.arraycopy(array, fromIndex, subArray, 0, subArray.length);
        return subArray;
    }

    public static double[] safeSubArray(double[] array, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (toIndex > array.length) {
            toIndex = array.length;
        }
        if (fromIndex >= toIndex) {
            return new double[0];
        }
        double[] subArray = new double[toIndex - fromIndex];
        System.arraycopy(array, fromIndex, subArray, 0, subArray.length);
        return subArray;
    }

    public static boolean[] safeSubArray(boolean[] array, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (toIndex > array.length) {
            toIndex = array.length;
        }
        if (fromIndex >= toIndex) {
            return new boolean[0];
        }
        boolean[] subArray = new boolean[toIndex - fromIndex];
        System.arraycopy(array, fromIndex, subArray, 0, subArray.length);
        return subArray;
    }

    public static char[] safeSubArray(char[] array, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (toIndex > array.length) {
            toIndex = array.length;
        }
        if (fromIndex >= toIndex) {
            return new char[0];
        }
        char[] subArray = new char[toIndex - fromIndex];
        System.arraycopy(array, fromIndex, subArray, 0, subArray.length);
        return subArray;
    }

    public static <T> T[] safeSubArray(T[] array, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (toIndex > array.length) {
            toIndex = array.length;
        }
        if (fromIndex >= toIndex) {
            return (Object[])Array.newInstance(array.getClass().componentType(), 0);
        }
        Object[] subArray = (Object[])Array.newInstance(array.getClass().componentType(), toIndex - fromIndex);
        System.arraycopy(array, fromIndex, subArray, 0, subArray.length);
        return subArray;
    }

    public static <T> List<List<T>> splitList(List<T> list, int size) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        for (int i = 0; i < list.size(); i += size) {
            int end = Math.min(i + size, list.size());
            result.add(list.subList(i, end));
        }
        return result;
    }

    public static <T> List<List<T>> splitListN(List<T> list, int n) {
        return ArrayUtils.splitList(list, ArrayUtils.numOfSlices(list.size(), n));
    }

    public static <T> List<T> subList(List<T> list, int fromIndex, int toIndex) {
        return list.subList(fromIndex, toIndex);
    }

    public static <T> List<T> safeSubList(List<T> list, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (toIndex > list.size()) {
            toIndex = list.size();
        }
        if (fromIndex >= toIndex) {
            return List.of();
        }
        return list.subList(fromIndex, toIndex);
    }

    public static Object[] toObjectArray(Object source) {
        if (source instanceof Object[]) {
            Object[] objectArr = (Object[])source;
            return objectArr;
        }
        if (source == null) {
            return new Object[0];
        }
        if (source instanceof Collection) {
            Collection collection = (Collection)source;
            return collection.toArray();
        }
        if (source.getClass().isArray()) {
            Object object = source;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{byte[].class, short[].class, int[].class, long[].class, float[].class, double[].class, boolean[].class, char[].class}, (Object)object2, n)) {
                case 0 -> {
                    byte[] arr = (byte[])object2;
                    yield ArrayUtils.toWrapper(arr);
                }
                case 1 -> {
                    short[] arr = (short[])object2;
                    yield ArrayUtils.toWrapper(arr);
                }
                case 2 -> {
                    int[] arr = (int[])object2;
                    yield ArrayUtils.toWrapper(arr);
                }
                case 3 -> {
                    long[] arr = (long[])object2;
                    yield ArrayUtils.toWrapper(arr);
                }
                case 4 -> {
                    float[] arr = (float[])object2;
                    yield ArrayUtils.toWrapper(arr);
                }
                case 5 -> {
                    double[] arr = (double[])object2;
                    yield ArrayUtils.toWrapper(arr);
                }
                case 6 -> {
                    boolean[] arr = (boolean[])object2;
                    yield ArrayUtils.toWrapper(arr);
                }
                case 7 -> {
                    char[] arr = (char[])object2;
                    yield ArrayUtils.toWrapper(arr);
                }
                default -> throw new IllegalStateException("\u9519\u8bef\u503c : " + String.valueOf(source));
            };
        }
        throw new IllegalArgumentException("\u6e90\u6570\u636e\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6570\u7ec4\u5bf9\u8c61 !!!");
    }

    public static long[] toLongArray(int ... intArray) {
        long[] longArray = new long[intArray.length];
        for (int i = 0; i < intArray.length; ++i) {
            longArray[i] = intArray[i];
        }
        return longArray;
    }
}

