/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.collections;

import cool.scx.collections.count_map.CountMap;
import cool.scx.collections.multi_map.MultiMap;
import java.util.function.Function;

public final class ScxCollections {
    public static <K, T> MultiMap<K, T> groupingBy(Iterable<T> list, Function<? super T, ? extends K> keyFn) {
        return ScxCollections.groupingBy(list, keyFn, (? super T t) -> t);
    }

    public static <K, V, T> MultiMap<K, V> groupingBy(Iterable<T> list, Function<? super T, ? extends K> keyFn, Function<? super T, ? extends V> valueFn) {
        MultiMap<K, V> multiMap = new MultiMap<K, V>();
        for (T t : list) {
            K key = keyFn.apply(t);
            V value = valueFn.apply(t);
            multiMap.add(key, value);
        }
        return multiMap;
    }

    public static <K, T> MultiMap<K, T> groupingBy(T[] list, Function<? super T, ? extends K> keyFn) {
        return ScxCollections.groupingBy(list, keyFn, (? super T t) -> t);
    }

    public static <K, V, T> MultiMap<K, V> groupingBy(T[] list, Function<? super T, ? extends K> keyFn, Function<? super T, ? extends V> valueFn) {
        MultiMap<K, V> multiMap = new MultiMap<K, V>();
        for (T t : list) {
            K key = keyFn.apply(t);
            V value = valueFn.apply(t);
            multiMap.add(key, value);
        }
        return multiMap;
    }

    public static <T> CountMap<T> countingBy(Iterable<T> list) {
        return ScxCollections.countingBy(list, (? super T k) -> k, (? super T t) -> 1L);
    }

    public static <K, T> CountMap<K> countingBy(Iterable<T> list, Function<? super T, ? extends K> keyFn) {
        return ScxCollections.countingBy(list, keyFn, (? super T t) -> 1L);
    }

    public static <K, T> CountMap<K> countingBy(Iterable<T> list, Function<? super T, ? extends K> keyFn, Function<? super T, Long> countFn) {
        CountMap<K> countMap = new CountMap<K>();
        for (T t : list) {
            K key = keyFn.apply(t);
            Long count = countFn.apply(t);
            if (count == null) continue;
            countMap.add(key, count);
        }
        return countMap;
    }

    public static <T> CountMap<T> countingBy(T[] list) {
        return ScxCollections.countingBy(list, (? super T k) -> k, (? super T t) -> 1L);
    }

    public static <K, T> CountMap<K> countingBy(T[] list, Function<? super T, ? extends K> keyFn) {
        return ScxCollections.countingBy(list, keyFn, (? super T t) -> 1L);
    }

    public static <K, T> CountMap<K> countingBy(T[] list, Function<? super T, ? extends K> keyFn, Function<? super T, Long> countFn) {
        CountMap<K> countMap = new CountMap<K>();
        for (T t : list) {
            K key = keyFn.apply(t);
            Long count = countFn.apply(t);
            if (count == null) continue;
            countMap.add(key, count);
        }
        return countMap;
    }
}

