/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.collections.count_map;

import cool.scx.collections.count_map.CountMapIterator;
import cool.scx.collections.count_map.ICountMap;
import cool.scx.collections.count_map.ICountMapEntry;
import cool.scx.function.ObjLongConsumerX;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class CountMap<K>
implements ICountMap<K> {
    private final Map<K, Long> map;

    public CountMap() {
        this(HashMap::new);
    }

    public CountMap(Supplier<Map<K, Long>> mapSupplier) {
        this.map = mapSupplier.get();
    }

    @Override
    public long add(K key, long count) {
        return this.map.merge(key, count, Long::sum);
    }

    @Override
    public Long set(K key, long count) {
        return this.map.put(key, count);
    }

    @Override
    public Long get(K key) {
        return this.map.get(key);
    }

    @Override
    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    @Override
    public Long remove(K key) {
        return this.map.remove(key);
    }

    @Override
    public Set<K> keys() {
        return this.map.keySet();
    }

    @Override
    public long size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Map<K, Long> toMap() {
        return this.toMap(HashMap::new);
    }

    @Override
    public Map<K, Long> toMap(Supplier<Map<K, Long>> mapSupplier) {
        Map<K, Long> result = mapSupplier.get();
        result.putAll(this.map);
        return result;
    }

    @Override
    public <X extends Throwable> void forEach(ObjLongConsumerX<? super K, X> action) throws X {
        for (Map.Entry<K, Long> entry : this.map.entrySet()) {
            K key = entry.getKey();
            Long value = entry.getValue();
            action.accept(key, value.longValue());
        }
    }

    @Override
    public Iterator<ICountMapEntry<K>> iterator() {
        return new CountMapIterator<K>(this.map.entrySet().iterator());
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CountMap) {
            CountMap o = (CountMap)object;
            return this.map.equals(o.map);
        }
        return false;
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }
}

