/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util;

import cool.scx.util.StringUtils;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class CaseUtils {
    private static final Pattern CAMEL_PATTERN = Pattern.compile("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");

    public static String toCamel(String str) {
        return CaseUtils.makeFirstCharLowerCase(CaseUtils.toPascal(str));
    }

    public static String toPascal(String str) {
        return Arrays.stream(CaseUtils.getSourceStrings(str)).map(s -> CaseUtils.makeFirstCharUpperCase(s.toLowerCase())).collect(Collectors.joining());
    }

    public static String toKebab(String str) {
        return Arrays.stream(CaseUtils.getSourceStrings(str)).map(String::toLowerCase).collect(Collectors.joining("-"));
    }

    public static String toSnake(String str) {
        return Arrays.stream(CaseUtils.getSourceStrings(str)).map(String::toLowerCase).collect(Collectors.joining("_"));
    }

    private static String[] getSourceStrings(String str) {
        if (StringUtils.isBlank(str)) {
            return new String[0];
        }
        if (str.contains("_")) {
            return str.split("_");
        }
        if (str.contains("-")) {
            return str.split("-");
        }
        return CAMEL_PATTERN.split(str);
    }

    private static String makeFirstCharUpperCase(String string) {
        char[] charArray = string.toCharArray();
        if ('a' <= charArray[0] && charArray[0] <= 'z') {
            charArray[0] = (char)(charArray[0] ^ 0x20);
        }
        return new String(charArray);
    }

    private static String makeFirstCharLowerCase(String string) {
        char[] charArray = string.toCharArray();
        if ('A' <= charArray[0] && charArray[0] <= 'Z') {
            charArray[0] = (char)(charArray[0] ^ 0x20);
        }
        return new String(charArray);
    }
}

