/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import cool.scx.util.JacksonHelper;
import cool.scx.util.StringUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ObjectUtils {
    public static final TypeReference<Map<String, Object>> MAP_TYPE = new TypeReference<Map<String, Object>>(){};
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final JsonMapper JSON_MAPPER = JacksonHelper.setIgnoreJsonIgnore(JacksonHelper.initJsonMapper());
    private static final XmlMapper XML_MAPPER = JacksonHelper.setIgnoreJsonIgnore(JacksonHelper.initXmlMapper());

    public static JsonMapper jsonMapper() {
        return JSON_MAPPER;
    }

    public static XmlMapper xmlMapper() {
        return XML_MAPPER;
    }

    public static JavaType constructType(Type type) {
        return JSON_MAPPER.getTypeFactory().constructType(type);
    }

    public static JavaType constructType(TypeReference<?> typeRef) {
        return ObjectUtils.constructType(typeRef.getType());
    }

    public static <T> T convertValue(Object fromValue, JavaType javaType) {
        return (T)JSON_MAPPER.convertValue(fromValue, javaType);
    }

    public static <T> T convertValue(Object fromValue, Class<T> tClass) {
        return ObjectUtils.convertValue(fromValue, ObjectUtils.constructType(tClass));
    }

    public static <T> T convertValue(Object fromValue, Type toValueType) {
        return ObjectUtils.convertValue(fromValue, ObjectUtils.constructType(toValueType));
    }

    public static <T> T convertValue(Object fromValue, TypeReference<T> toValueTypeRef) {
        return ObjectUtils.convertValue(fromValue, ObjectUtils.constructType(toValueTypeRef));
    }

    public static String toJson(Object value, String defaultValue) {
        try {
            return ObjectUtils.toJson(value);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public static String toXml(Object value, String defaultValue) {
        try {
            return ObjectUtils.toXml(value);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public static String toJson(Object value) throws JsonProcessingException {
        return JSON_MAPPER.writeValueAsString(value);
    }

    public static String toXml(Object value) throws JsonProcessingException {
        return XML_MAPPER.writeValueAsString(value);
    }

    public static Object[] toObjectArray(Object source) {
        if (source instanceof Object[]) {
            return (Object[])source;
        }
        if (source == null) {
            return EMPTY_OBJECT_ARRAY;
        }
        if (source instanceof Collection) {
            return ((Collection)source).toArray();
        }
        if (source.getClass().isArray()) {
            int length = Array.getLength(source);
            Object[] arr = new Object[length];
            if (source instanceof byte[]) {
                byte[] arrSource = (byte[])source;
                for (int i = 0; i < length; ++i) {
                    arr[i] = arrSource[i];
                }
            } else if (source instanceof short[]) {
                short[] arrSource = (short[])source;
                for (int i = 0; i < length; ++i) {
                    arr[i] = arrSource[i];
                }
            } else if (source instanceof int[]) {
                int[] arrSource = (int[])source;
                for (int i = 0; i < length; ++i) {
                    arr[i] = arrSource[i];
                }
            } else if (source instanceof long[]) {
                long[] arrSource = (long[])source;
                for (int i = 0; i < length; ++i) {
                    arr[i] = arrSource[i];
                }
            } else if (source instanceof float[]) {
                float[] arrSource = (float[])source;
                for (int i = 0; i < length; ++i) {
                    arr[i] = Float.valueOf(arrSource[i]);
                }
            } else if (source instanceof double[]) {
                double[] arrSource = (double[])source;
                for (int i = 0; i < length; ++i) {
                    arr[i] = arrSource[i];
                }
            } else if (source instanceof boolean[]) {
                boolean[] arrSource = (boolean[])source;
                for (int i = 0; i < length; ++i) {
                    arr[i] = arrSource[i];
                }
            } else if (source instanceof char[]) {
                char[] arrSource = (char[])source;
                for (int i = 0; i < length; ++i) {
                    arr[i] = Character.valueOf(arrSource[i]);
                }
            }
            return arr;
        }
        throw new IllegalArgumentException("\u6e90\u6570\u636e\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6570\u7ec4\u5bf9\u8c61 !!!");
    }

    private static Map<String, Object> flatMap0(Map<?, ?> sourceMap, String parentKey) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Object prefix = StringUtils.isBlank(parentKey) ? "" : parentKey + ".";
        sourceMap.forEach((arg_0, arg_1) -> ObjectUtils.lambda$flatMap0$0((String)prefix, result, arg_0, arg_1));
        return result;
    }

    public static Map<String, Object> flatMap(Map<?, ?> sourceMap) {
        return ObjectUtils.flatMap0(sourceMap, null);
    }

    private static /* synthetic */ void lambda$flatMap0$0(String prefix, LinkedHashMap result, Object key, Object value) {
        String newKey = prefix + key;
        if (value instanceof Map) {
            Map m = (Map)value;
            result.putAll(ObjectUtils.flatMap0(m, newKey));
        } else {
            result.put(newKey, value);
        }
    }
}

