/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util;

import cool.scx.util.exception.ScxExceptionHelper;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;

public final class ScanClassUtils {
    private static final ClassLoader DEFAULT_CLASS_LOADER = ScanClassUtils.class.getClassLoader();

    public static List<Class<?>> getClassListByJar(URI jarFileURI) throws IOException {
        try (JarFile jarFile = new JarFile(new File(jarFileURI));){
            List<Class<?>> list;
            try (URLClassLoader jarClassLoader = new URLClassLoader(new URL[]{jarFileURI.toURL()});){
                list = jarFile.stream().filter(jarEntry -> !jarEntry.isDirectory() && jarEntry.getName().endsWith(".class")).map(jarEntry -> ScanClassUtils.loadClass(jarEntry, (ClassLoader)jarClassLoader)).collect(Collectors.toList());
            }
            return list;
        }
    }

    public static List<Class<?>> getClassListByDir(URI classRootDir, final ClassLoader classLoader) throws IOException {
        final ArrayList classList = new ArrayList();
        final Path classRootPath = Path.of(classRootDir);
        Files.walkFileTree(classRootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                if (path.toString().endsWith(".class")) {
                    Path classRealPath = classRootPath.relativize(path);
                    classList.add(ScanClassUtils.loadClass(classRealPath, classLoader));
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return classList;
    }

    private static Class<?> loadClass(JarEntry jarEntry, ClassLoader jarClassLoader) {
        int suffixLength = ".class".length();
        String className = jarEntry.getName().substring(0, jarEntry.getName().length() - suffixLength).replace('/', '.');
        return ScanClassUtils.loadClass0(className, jarClassLoader);
    }

    private static Class<?> loadClass(Path classRealPath, ClassLoader classLoader) {
        int suffixLength = ".class.".length();
        StringBuilder str = new StringBuilder();
        for (Path path : classRealPath) {
            str.append(path.toString()).append(".");
        }
        String className = str.substring(0, str.length() - suffixLength);
        return ScanClassUtils.loadClass0(className, classLoader);
    }

    public static URI getClassSource(Class<?> source) throws URISyntaxException {
        return source.getProtectionDomain().getCodeSource().getLocation().toURI();
    }

    private static Class<?> loadClass0(String className, ClassLoader classLoader) {
        try {
            return DEFAULT_CLASS_LOADER.loadClass(className);
        }
        catch (Throwable t1) {
            try {
                return classLoader.loadClass(className);
            }
            catch (Throwable t2) {
                return null;
            }
        }
    }

    public static List<Class<?>> filterByBasePackage(List<Class<?>> classList, String basePackageName) {
        return classList.stream().filter(c -> c.getPackageName().startsWith(basePackageName)).collect(Collectors.toList());
    }

    public static boolean isJar(Path path) {
        return !Files.isDirectory(path, new LinkOption[0]) && path.toString().endsWith(".jar");
    }

    public static boolean isInstantiableClass(Class<?> c) {
        return ScanClassUtils.isNormalClass(c) && ScxExceptionHelper.noException(() -> c.getConstructor(new Class[0]).newInstance(new Object[0]));
    }

    public static boolean isNormalClass(Class<?> c) {
        return !c.isInterface() && !Modifier.isAbstract(c.getModifiers());
    }
}

