/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util.zip;

import cool.scx.util.tree.ScxTree;
import cool.scx.util.tree.ScxTreeUtil;
import cool.scx.util.zip.VirtualDirectory;
import cool.scx.util.zip.VirtualFile;
import cool.scx.util.zip.VirtualFileVisitor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public abstract class AbstractVirtualFile
implements ScxTree<AbstractVirtualFile> {
    protected final String name;
    protected final List<AbstractVirtualFile> children;
    protected AbstractVirtualFile parent;

    public AbstractVirtualFile(String name, List<AbstractVirtualFile> children) {
        this.name = name;
        this.children = children;
    }

    private static void writeVirtualFileToZipOutputStream(AbstractVirtualFile virtualFile, final ZipOutputStream zos) throws Exception {
        virtualFile.walk(new VirtualFileVisitor(){

            @Override
            public void visitDirectory(String path) throws IOException {
                ZipEntry zipEntry = new ZipEntry(path);
                zos.putNextEntry(zipEntry);
                zos.closeEntry();
            }

            @Override
            public void visitFile(String path, byte[] bytes) throws IOException {
                ZipEntry zipEntry = new ZipEntry(path);
                zos.putNextEntry(zipEntry);
                zos.write(bytes);
                zos.closeEntry();
            }
        });
    }

    private static String getFullPath(List<AbstractVirtualFile> abstractVirtualFiles1, AbstractVirtualFile ... abstractVirtualFiles2) {
        ArrayList<AbstractVirtualFile> fullList = new ArrayList<AbstractVirtualFile>();
        if (abstractVirtualFiles1 != null) {
            fullList.addAll(abstractVirtualFiles1);
        }
        Collections.addAll(fullList, abstractVirtualFiles2);
        return fullList.stream().map(f -> f.name).collect(Collectors.joining("/"));
    }

    public final void setParent(AbstractVirtualFile parent) {
        this.parent = parent;
    }

    @Override
    public final AbstractVirtualFile parent() {
        return this.parent;
    }

    @Override
    public final List<AbstractVirtualFile> children() {
        return this.children;
    }

    public byte[] toZipBytes() throws Exception {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try (ZipOutputStream zos = new ZipOutputStream(bo);){
            AbstractVirtualFile.writeVirtualFileToZipOutputStream(this, zos);
        }
        return bo.toByteArray();
    }

    public void toZipFile(Path outputPath) throws Exception {
        Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        try (ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(outputPath, new OpenOption[0]));){
            AbstractVirtualFile.writeVirtualFileToZipOutputStream(this, zos);
        }
    }

    public void walk(VirtualFileVisitor visitor) throws Exception {
        ScxTreeUtil.walk(this, (parent, self) -> {
            String fullPath = AbstractVirtualFile.getFullPath(parent, self);
            if (self instanceof VirtualFile) {
                visitor.visitFile(fullPath, ((VirtualFile)self).getBytes());
            } else if (self instanceof VirtualDirectory) {
                visitor.visitDirectory(fullPath + "/");
            }
        });
    }
}

