/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util.http;

import cool.scx.util.RandomUtils;
import cool.scx.util.ScxExceptionHelper;
import cool.scx.util.http.Body;
import io.netty5.buffer.BufferUtil;
import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.BufferAllocator;
import io.netty5.buffer.api.CompositeBuffer;
import io.netty5.handler.codec.http.HttpHeaderNames;
import io.netty5.handler.codec.http.HttpHeaderValues;
import io.vertx.core.http.impl.MimeMapping;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public final class FormData
implements Body {
    private static final String FORM_BOUNDARY_PREFIX = "----ScxHttpClientHelperFormBoundary";
    private static final String lineSeparator = "\r\n";
    private static final byte[] lineSeparatorBytes = "\r\n".getBytes(StandardCharsets.UTF_8);
    private final List<FormDataItem> formDataItemList = new ArrayList<FormDataItem>();

    private static byte[] getStart(FormDataItem f, String boundary) {
        String headerStr = f.filename == null ? "Content-Disposition: form-data; name=\"" + f.name + "\"" : "Content-Disposition: form-data; name=\"" + f.name + "\"; filename=\"" + f.filename + "\"";
        String finalHeader = f.contentType == null ? headerStr : headerStr + "\r\nContent-Type: " + f.contentType;
        String start = "--" + boundary + lineSeparator + finalHeader + "\r\n\r\n";
        return start.getBytes(StandardCharsets.UTF_8);
    }

    private static byte[] getContent(FormDataItem nowItem) {
        return switch (nowItem.type) {
            default -> throw new IncompatibleClassChangeError();
            case FormDataItemType.CONTENT -> nowItem.content;
            case FormDataItemType.FILE -> ScxExceptionHelper.wrap(() -> Files.readAllBytes(nowItem.filePath));
        };
    }

    private static byte[] getEnd(String boundary) {
        String end = "--" + boundary + "--";
        return end.getBytes(StandardCharsets.UTF_8);
    }

    public FormData add(String name, Object text) {
        this.formDataItemList.add(new FormDataItem(name, text.toString()));
        return this;
    }

    public FormData addFile(String name, Path filePath) {
        this.formDataItemList.add(new FormDataItem(name, filePath));
        return this;
    }

    public FormData addFile(String name, byte[] fileByte, String filename, String contentType) {
        this.formDataItemList.add(new FormDataItem(name, fileByte, filename, contentType));
        return this;
    }

    public FormData addFile(String name, byte[] fileByte, String filename) {
        this.formDataItemList.add(new FormDataItem(name, fileByte, filename));
        return this;
    }

    public FormData remove(String name) {
        this.formDataItemList.removeIf(formDataItem -> name.equals(formDataItem.name));
        return this;
    }

    @Override
    public HttpRequest.BodyPublisher getBodyPublisher(HttpRequest.Builder builder) {
        String boundary = FORM_BOUNDARY_PREFIX + RandomUtils.randomString(8);
        builder.setHeader(HttpHeaderNames.CONTENT_TYPE.toString(), HttpHeaderValues.MULTIPART_FORM_DATA + "; boundary=" + boundary);
        try (BufferAllocator allocator = BufferAllocator.onHeapUnpooled();){
            HttpRequest.BodyPublisher bodyPublisher;
            block13: {
                CompositeBuffer buffer = allocator.compose();
                try {
                    for (FormDataItem formDataItem : this.formDataItemList) {
                        buffer.writeBytes(FormData.getStart(formDataItem, boundary));
                        buffer.writeBytes(FormData.getContent(formDataItem));
                        buffer.writeBytes(lineSeparatorBytes);
                    }
                    buffer.writeBytes(FormData.getEnd(boundary));
                    bodyPublisher = HttpRequest.BodyPublishers.ofByteArray(BufferUtil.getBytes((Buffer)buffer));
                    if (buffer == null) break block13;
                }
                catch (Throwable throwable) {
                    if (buffer != null) {
                        try {
                            buffer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                buffer.close();
            }
            return bodyPublisher;
        }
    }

    static final class FormDataItem {
        final FormDataItemType type;
        final String name;
        final String filename;
        final String contentType;
        Path filePath;
        byte[] content;

        FormDataItem(String name, Object text) {
            this(name, text.toString().getBytes(StandardCharsets.UTF_8), null, null);
        }

        FormDataItem(String name, byte[] content, String filename) {
            this(name, content, filename, MimeMapping.getMimeTypeForFilename((String)filename));
        }

        FormDataItem(String name, byte[] content, String filename, String contentType) {
            this.type = FormDataItemType.CONTENT;
            this.name = name;
            this.content = content;
            this.filename = filename;
            this.contentType = contentType;
        }

        FormDataItem(String name, Path filePath) {
            this.type = FormDataItemType.FILE;
            this.name = name;
            this.filePath = filePath;
            this.filename = this.filePath.getFileName().toString();
            this.contentType = MimeMapping.getMimeTypeForFilename((String)this.filename);
        }
    }

    static enum FormDataItemType {
        CONTENT,
        FILE;

    }
}

