/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util.zip;

import cool.scx.util.zip.AbstractVirtualFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;

public final class VirtualFile
extends AbstractVirtualFile {
    private final File physicalFile;
    private final byte[] bytes;
    private final int type;

    private VirtualFile(File physicalFile, byte[] bytes, String fileName, int type) {
        super(fileName, null);
        this.physicalFile = physicalFile;
        this.bytes = bytes;
        this.type = type;
    }

    public static VirtualFile of(File physicalFile) {
        return new VirtualFile(physicalFile, null, physicalFile.getName(), 0);
    }

    public static VirtualFile of(String name, File physicalFile) {
        return new VirtualFile(physicalFile, null, name, 0);
    }

    public static VirtualFile of(String name, byte[] bytes) {
        return new VirtualFile(null, bytes, name, 1);
    }

    public byte[] getBytes() throws IOException {
        if (this.type == 0) {
            return Files.readAllBytes(this.physicalFile.toPath());
        }
        return this.bytes;
    }
}

