/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util.tree;

import cool.scx.util.MultiMap;
import cool.scx.util.tree.ScxTree;
import cool.scx.util.tree.ScxTreeModel;
import cool.scx.util.tree.ScxTreeVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class ScxTreeUtil {
    public static <T extends ScxTree<T>> void walk1(T scxTree, ScxTreeVisitor<T> visitor) throws Exception {
        ArrayList<T> parents = null;
        T now = scxTree;
        while (now.parent() != null) {
            if (parents == null) {
                parents = new ArrayList<T>();
            }
            parents.add(0, now.parent());
            now = now.parent();
        }
        visitor.handle(parents, scxTree);
        if (scxTree.children() != null) {
            for (ScxTree child : scxTree.children()) {
                ScxTreeUtil.walk1(child, visitor);
            }
        }
    }

    public static <T extends ScxTree<T>> void walk(T scxTree, ScxTreeVisitor<T> visitor) throws Exception {
        ScxTreeUtil._walk(null, scxTree, visitor);
    }

    private static <T extends ScxTree<T>> void _walk(List<T> parents, T currentScxTree, ScxTreeVisitor<T> visitor) throws Exception {
        visitor.handle(parents, currentScxTree);
        ArrayList<T> newParents = parents == null ? new ArrayList<T>() : new ArrayList<T>(parents);
        newParents.add(currentScxTree);
        if (currentScxTree.children() != null) {
            for (ScxTree child : currentScxTree.children()) {
                ScxTreeUtil._walk(newParents, child, visitor);
            }
        }
    }

    public static <T extends ScxTreeModel<T>> List<T> listToTree(List<T> list) {
        return ScxTreeUtil.listToTree(list, false);
    }

    public static <T extends ScxTreeModel<T>> List<T> listToTree(List<T> list, boolean ignoreOrphans) {
        if (list == null) {
            throw new IllegalArgumentException("listToTree : \u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a !!!");
        }
        HashMap<Long, ScxTreeModel> idMap = new HashMap<Long, ScxTreeModel>(list.size());
        MultiMap<Long, ScxTreeModel> parentIDMap = new MultiMap<Long, ScxTreeModel>();
        for (ScxTreeModel t : list) {
            idMap.put(t.id(), t);
            parentIDMap.put(t.parentID(), t);
        }
        return list.stream().filter(my -> {
            List myChildren;
            boolean isOrphan;
            Long myID = my.id();
            Long parentID = my.parentID();
            boolean bl = isOrphan = !ignoreOrphans && (parentID == null || idMap.get(parentID) == null);
            if (myID != null && (myChildren = parentIDMap.get(myID)).size() > 0) {
                my.children(myChildren);
            }
            return my.isRoot() || isOrphan;
        }).toList();
    }
}

