/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util;

import cool.scx.util.StringUtils;
import cool.scx.util.case_impl.CaseType;

public final class CaseUtils {
    public static String toCamel(String str) {
        return CaseUtils.toCamel(str, CaseUtils.deduceCaseType(str));
    }

    public static String toPascal(String str) {
        return CaseUtils.toPascal(str, CaseUtils.deduceCaseType(str));
    }

    public static String toKebab(String str) {
        return CaseUtils.toKebab(str, CaseUtils.deduceCaseType(str));
    }

    public static String toSnake(String str) {
        return CaseUtils.toSnake(str, CaseUtils.deduceCaseType(str));
    }

    public static String toCamel(String str, CaseType caseType) {
        return CaseUtils.convert(str, CaseType.CAMEL_CASE, caseType);
    }

    public static String toPascal(String str, CaseType caseType) {
        return CaseUtils.convert(str, CaseType.PASCAL_CASE, caseType);
    }

    public static String toKebab(String str, CaseType caseType) {
        return CaseUtils.convert(str, CaseType.KEBAB_CASE, caseType);
    }

    public static String toSnake(String str, CaseType caseType) {
        return CaseUtils.convert(str, CaseType.SNAKE_CASE, caseType);
    }

    private static String convert(String str, CaseType to, CaseType from) {
        return from == to ? str : to.getString(from.getSourceStrings(str));
    }

    private static CaseType deduceCaseType(String str) {
        if (StringUtils.isBlank(str)) {
            return CaseType.BLANK;
        }
        if (str.contains("_")) {
            return CaseType.SNAKE_CASE;
        }
        if (str.contains("-")) {
            return CaseType.KEBAB_CASE;
        }
        return CaseType.PASCAL_CASE;
    }
}

