/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperBuilder;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public final class JacksonHelper {
    private static final NullKeySerializer DEFAULT_NULL_KEY_SERIALIZER = new NullKeySerializer();
    private static final DateTimeFormatter DEFAULT_DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    private static JavaTimeModule initJavaTimeModule(DateTimeFormatter dateTimeFormatter) {
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(dateTimeFormatter));
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(dateTimeFormatter));
        return javaTimeModule;
    }

    public static JsonMapper initJsonMapper(DateTimeFormatter formatter) {
        return (JsonMapper)JacksonHelper.initObjectMapper(JsonMapper.builder(), formatter);
    }

    public static JsonMapper initJsonMapper() {
        return JacksonHelper.initJsonMapper(DEFAULT_DATETIME_FORMATTER);
    }

    public static XmlMapper initXmlMapper(DateTimeFormatter formatter) {
        return (XmlMapper)JacksonHelper.initObjectMapper(XmlMapper.builder(), formatter);
    }

    public static XmlMapper initXmlMapper() {
        return JacksonHelper.initXmlMapper(DEFAULT_DATETIME_FORMATTER);
    }

    static <M extends ObjectMapper, B extends MapperBuilder<M, B>> M initObjectMapper(MapperBuilder<M, B> mapperBuilder, DateTimeFormatter formatter) {
        ObjectMapper objectMapper = mapperBuilder.addModule((Module)JacksonHelper.initJavaTimeModule(formatter)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).build();
        objectMapper.getSerializerProvider().setNullKeySerializer((JsonSerializer)DEFAULT_NULL_KEY_SERIALIZER);
        return (M)objectMapper;
    }

    static <M extends ObjectMapper> M setIgnoreJsonIgnore(M mapper) {
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new IgnoreJsonIgnore());
        return mapper;
    }

    static <M extends ObjectMapper> M setIgnoreNullValue(M mapper) {
        mapper.setDefaultPropertyInclusion(JsonInclude.Include.NON_NULL);
        return mapper;
    }

    private static class NullKeySerializer
    extends JsonSerializer<Object> {
        public static final String NULL_KEY = "";

        private NullKeySerializer() {
        }

        public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value != null) {
                throw JsonMappingException.from((JsonGenerator)gen, (String)"NullKeySerializer is only for serializing null values.");
            }
            gen.writeFieldName(NULL_KEY);
        }
    }

    private static class IgnoreJsonIgnore
    extends JacksonAnnotationIntrospector {
        private IgnoreJsonIgnore() {
        }

        public boolean hasIgnoreMarker(AnnotatedMember m) {
            return false;
        }
    }
}

