/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public final class MultiMap<K, V> {
    private final Map<K, List<V>> map = new LinkedHashMap<K, List<V>>();
    private int size = 0;

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(V value) {
        return this.map.values().stream().anyMatch(collection -> collection.contains(value));
    }

    public List<V> get(K key) {
        return this.map.computeIfAbsent(key, k -> new ArrayList());
    }

    public boolean put(K key, V value) {
        List<V> collection = this.get(key);
        ++this.size;
        return collection.add(value);
    }

    public boolean putAll(K key, List<? extends V> values) {
        this.size += values.size();
        return !values.isEmpty() && this.get(key).addAll(values);
    }

    public boolean remove(K key, V value) {
        List<V> collection = this.map.get(key);
        if (collection != null && collection.remove(value)) {
            --this.size;
            return true;
        }
        return false;
    }

    public List<V> removeAll(K key) {
        List<V> collection = this.map.remove(key);
        if (collection == null) {
            return Collections.emptyList();
        }
        ArrayList<V> output = new ArrayList<V>(collection);
        this.size -= collection.size();
        collection.clear();
        return Collections.unmodifiableList(output);
    }

    public void clear() {
        for (List<V> collection : this.map.values()) {
            collection.clear();
        }
        this.map.clear();
        this.size = 0;
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public List<V> values() {
        return this.map.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Map<K, List<V>> asMap() {
        return this.map;
    }

    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.map.forEach((key, valueCollection) -> valueCollection.forEach((? super T value) -> action.accept((Object)key, (Object)value)));
    }
}

