/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util;

import cool.scx.util.MultiMap;
import cool.scx.util.StringUtils;
import io.netty5.handler.codec.http.QueryStringDecoder;
import io.netty5.handler.codec.http.QueryStringEncoder;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class URIBuilder {
    private final String path;
    private final MultiMap<String, String> queryParams = new MultiMap();

    private URIBuilder(QueryStringDecoder decoder) {
        this.path = decoder.path();
        decoder.parameters().forEach(this.queryParams::putAll);
    }

    public static URIBuilder of(String str) {
        return new URIBuilder(new QueryStringDecoder(str, StandardCharsets.UTF_8));
    }

    public static URIBuilder of(URI uri) {
        return new URIBuilder(new QueryStringDecoder(uri, StandardCharsets.UTF_8));
    }

    public static String join(String ... uris) {
        return Arrays.stream(String.join((CharSequence)"/", uris).split("/")).filter(StringUtils::notBlank).collect(Collectors.joining("/", "/", ""));
    }

    public URIBuilder addParam(String key, Object value) {
        this.queryParams.put(key, value.toString());
        return this;
    }

    public URIBuilder removeParam(String key) {
        this.queryParams.removeAll(key);
        return this;
    }

    public List<String> getParams(String key) {
        return this.queryParams.get(key);
    }

    public Map<String, List<String>> getAllParams() {
        return this.queryParams.asMap();
    }

    public URIBuilder removeAllParams() {
        this.queryParams.clear();
        return this;
    }

    public URI build() {
        return URI.create(this.toString());
    }

    public String toString() {
        QueryStringEncoder encoder = new QueryStringEncoder(this.path, StandardCharsets.UTF_8);
        this.queryParams.forEach((arg_0, arg_1) -> ((QueryStringEncoder)encoder).addParam(arg_0, arg_1));
        return encoder.toString();
    }
}

