/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util.case_impl;

import cool.scx.util.case_impl.CaseTypeHandler;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class PascalCaseHandler
implements CaseTypeHandler {
    private static final Pattern SPLIT_PATTERN = Pattern.compile("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");

    PascalCaseHandler() {
    }

    private static String makeFirstCharUpperCase(String string) {
        char[] charArray = string.toCharArray();
        if ('a' <= charArray[0] && charArray[0] <= 'z') {
            charArray[0] = (char)(charArray[0] ^ 0x20);
        }
        return new String(charArray);
    }

    @Override
    public String[] getSourceStrings(String s) {
        return SPLIT_PATTERN.split(s);
    }

    @Override
    public String getString(String[] ss) {
        return Arrays.stream(ss).map(s -> PascalCaseHandler.makeFirstCharUpperCase(s.toLowerCase())).collect(Collectors.joining());
    }
}

