/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util.http;

import cool.scx.util.ScxExceptionHelper;
import cool.scx.util.http.Body;
import cool.scx.util.http.EmptyBody;
import cool.scx.util.http.Options;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;

public final class HttpClientHelper {
    public static final HttpClient DEFAULT_HTTP_CLIENT = HttpClient.newBuilder().build();
    private static final HttpResponse.BodyHandler<String> DEFAULT_RESPONSE_BODY_HANDLER = HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8);

    public static HttpResponse<String> get(String url) {
        return HttpClientHelper.get(url, null);
    }

    public static HttpResponse<String> get(String url, Options options) {
        return HttpClientHelper.request(url, "GET", null, options);
    }

    public static HttpResponse<String> post(String url) {
        return HttpClientHelper.post(url, null);
    }

    public static HttpResponse<String> post(String url, Body body) {
        return HttpClientHelper.post(url, body, null);
    }

    public static HttpResponse<String> post(String url, Body body, Options options) {
        return HttpClientHelper.request(url, "POST", body, options);
    }

    public static HttpResponse<String> delete(String url) {
        return HttpClientHelper.delete(url, null);
    }

    public static HttpResponse<String> delete(String url, Options options) {
        return HttpClientHelper.request(url, "DELETE", null, options);
    }

    public static HttpResponse<String> put(String url) {
        return HttpClientHelper.put(url, null);
    }

    public static HttpResponse<String> put(String url, Body body) {
        return HttpClientHelper.put(url, body, null);
    }

    public static HttpResponse<String> put(String url, Body body, Options options) {
        return HttpClientHelper.request(url, "PUT", body, options);
    }

    private static HttpResponse<String> request(String url, String method, Body body, Options options) {
        return ScxExceptionHelper.wrap(() -> {
            Body b = body != null ? body : new EmptyBody();
            Options o = options != null ? options : new Options();
            HttpClient httpClient = o.httpClient() != null ? o.httpClient() : DEFAULT_HTTP_CLIENT;
            HttpRequest.Builder httpRequestBuilder = o.getHttpRequestBuilder().uri(URI.create(url));
            HttpRequest.BodyPublisher bodyPublisher = b.getBodyPublisher(httpRequestBuilder);
            HttpRequest httpRequest = switch (method) {
                case "GET" -> httpRequestBuilder.GET().build();
                case "POST" -> httpRequestBuilder.POST(bodyPublisher).build();
                case "DELETE" -> httpRequestBuilder.DELETE().build();
                case "PUT" -> httpRequestBuilder.PUT(bodyPublisher).build();
                default -> throw new IllegalArgumentException("\u672a\u77e5\u7684 method : " + method);
            };
            return httpClient.send(httpRequest, DEFAULT_RESPONSE_BODY_HANDLER);
        });
    }
}

