/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util.zip;

import cool.scx.util.StringUtils;
import cool.scx.util.zip.AbstractVirtualFile;
import java.util.ArrayList;
import java.util.Arrays;

public final class VirtualDirectory
extends AbstractVirtualFile {
    private VirtualDirectory(String directoryName) {
        super(directoryName, new ArrayList<AbstractVirtualFile>());
    }

    public static VirtualDirectory of() {
        return new VirtualDirectory(null);
    }

    public static VirtualDirectory of(String directoryName) {
        return new VirtualDirectory(directoryName);
    }

    private static String[] getValidPaths(String paths) {
        if (StringUtils.notBlank(paths)) {
            return (String[])Arrays.stream(paths.split("/")).filter(StringUtils::notBlank).toArray(String[]::new);
        }
        throw new IllegalArgumentException("Path \u4e0d\u80fd\u4e3a\u7a7a");
    }

    public VirtualDirectory put(String pathStr, AbstractVirtualFile virtualFile) {
        AbstractVirtualFile childrenByPath = this.getOrCreate(pathStr);
        if (!(childrenByPath instanceof VirtualDirectory)) {
            throw new IllegalArgumentException("\u8def\u5f84\u4e3a [" + pathStr + "] \u7684\u865a\u62df\u6587\u4ef6\u4e0d\u662f\u76ee\u5f55, \u65e0\u6cd5\u6dfb\u52a0\u5b50\u6587\u4ef6\u6216\u5b50\u76ee\u5f55 !!!");
        }
        ((VirtualDirectory)childrenByPath).put(virtualFile);
        return this;
    }

    public VirtualDirectory put(AbstractVirtualFile virtualFile) {
        for (AbstractVirtualFile child : this.children) {
            if (child.name == null || !child.name.equalsIgnoreCase(virtualFile.name)) continue;
            throw new IllegalArgumentException("\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0\u76f8\u540c\u540d\u79f0\u7684 IVirtualFile : " + virtualFile.name);
        }
        virtualFile.setParent(this);
        this.children.add(virtualFile);
        return this;
    }

    public AbstractVirtualFile get(String pathStr) {
        String[] paths = VirtualDirectory.getValidPaths(pathStr);
        VirtualDirectory findByPath = this;
        for (String path : paths) {
            if (findByPath == null) break;
            findByPath = findByPath instanceof VirtualDirectory ? findByPath.findChildren(path) : null;
        }
        if (findByPath == null) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u8def\u5f84\u4e3a [" + pathStr + "] \u7684\u865a\u62df\u6587\u4ef6 !!!");
        }
        return findByPath;
    }

    public AbstractVirtualFile getOrCreate(String pathStr) {
        String[] paths = VirtualDirectory.getValidPaths(pathStr);
        AbstractVirtualFile findByPath = this;
        int deep = 1;
        for (String path : paths) {
            AbstractVirtualFile tempChildren;
            AbstractVirtualFile abstractVirtualFile = tempChildren = findByPath instanceof VirtualDirectory ? ((VirtualDirectory)findByPath).findChildren(path) : null;
            if (paths.length == 1 || deep == paths.length || tempChildren == null || tempChildren instanceof VirtualDirectory) {
                if (tempChildren == null && findByPath instanceof VirtualDirectory) {
                    VirtualDirectory temp = VirtualDirectory.of(path);
                    ((VirtualDirectory)findByPath).put(temp);
                    findByPath = temp;
                } else {
                    findByPath = tempChildren;
                }
            } else {
                throw new IllegalArgumentException("\u8def\u5f84\u4e3a [" + String.join((CharSequence)"/", Arrays.copyOfRange(paths, 0, deep)) + "] \u5df2\u5b58\u5728\u6587\u4ef6, \u65e0\u6cd5\u6dfb\u52a0\u5b50\u6587\u4ef6\u6216\u5b50\u76ee\u5f55 !!!");
            }
            ++deep;
        }
        return findByPath;
    }

    public AbstractVirtualFile findChildren(String name) {
        for (AbstractVirtualFile child : this.children) {
            if (child.name == null || !child.name.equalsIgnoreCase(name)) continue;
            return child;
        }
        return null;
    }
}

