/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util;

import cool.scx.functional.ScxHandlerE;
import cool.scx.functional.ScxHandlerRE;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;

public final class ScxExceptionHelper {
    public static <T> T wrap(ScxHandlerRE<T, ?> handler) {
        try {
            return handler.handle();
        }
        catch (Throwable throwable) {
            throw new ScxWrappedRuntimeException(throwable);
        }
    }

    public static void wrap(ScxHandlerE<?> handler) {
        try {
            handler.handle();
        }
        catch (Throwable throwable) {
            throw new ScxWrappedRuntimeException(throwable);
        }
    }

    public static <T> T ignore(ScxHandlerRE<T, ?> handler) {
        try {
            return handler.handle();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static <T> T ignore(ScxHandlerRE<T, ?> handler, T defaultVal) {
        try {
            return handler.handle();
        }
        catch (Throwable throwable) {
            return defaultVal;
        }
    }

    public static void ignore(ScxHandlerE<?> handler) {
        try {
            handler.handle();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean noException(ScxHandlerE<?> exceptionScxHandlerVE) {
        try {
            exceptionScxHandlerVE.handle();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static Throwable getRootCause(Throwable throwable) {
        if (throwable instanceof ScxWrappedRuntimeException || throwable instanceof ExecutionException || throwable instanceof CompletionException) {
            return ScxExceptionHelper.getRootCause(throwable.getCause());
        }
        return throwable;
    }

    public static String getStackTraceString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.getBuffer().toString();
    }

    public static final class ScxWrappedRuntimeException
    extends RuntimeException {
        public ScxWrappedRuntimeException(Throwable cause) {
            super(cause);
        }
    }
}

